/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.htmlSanitizer=void 0;const fsp=require("path/posix"),prom_client_1=require("prom-client"),workerpool=require("workerpool"),__1=require(".."),custom_metrics_1=require("../metrics/prometheus/custom-metrics"),loggers_1=require("./loggers"),workerFile=fsp.join(__dirname,"xss-worker.js"),{sanitizeHtml}=require(workerFile),poolMetrics=custom_metrics_1.allMetricsEnabled?{workersThreads:new prom_client_1.Gauge({name:"xtrem_worker_threads_stats",help:"The worker threads stats",labelNames:["statName"]}),workerTasks:new prom_client_1.Gauge({name:"xtrem_workers_tasks_stats",help:"The worker tasks stats",labelNames:["statName"]})}:{};let _pool;const pool=()=>{if(!_pool)_pool=workerpool.pool(workerFile,{onCreateWorker:e=>(loggers_1.logger.info(`Create worker thread: ${e.script?.replace(/^.*\/build\//,".../build/")} stats:${JSON.stringify(_pool.stats())}`),void updateWorkerMetrics()),onTerminateWorker:e=>{loggers_1.logger.info(`Terminate worker thread: ${e.script?.replace(/^.*\/build\//,".../build/")} stats:${JSON.stringify(_pool.stats())}`)}}),updateWorkerMetrics(),custom_metrics_1.CustomMetrics.emitter.on("collected",()=>{if(Date.now()-updateStamp>15e3)updateWorkerMetrics()});return _pool};let updateStamp=Date.now();function updateWorkerMetrics(){if(!_pool)return;updateStamp=Date.now();const e=_pool.stats();if(poolMetrics.workersThreads)poolMetrics.workersThreads.set({statName:"busy"},e.busyWorkers),poolMetrics.workersThreads.set({statName:"idle"},e.idleWorkers),poolMetrics.workersThreads.set({statName:"total"},e.totalWorkers);if(poolMetrics.workerTasks)poolMetrics.workerTasks.set({statName:"active"},e.activeTasks),poolMetrics.workerTasks.set({statName:"pending"},e.pendingTasks)}const htmlLengthSyncThreshold=10240;function htmlSanitizer(e,r){if(!e)return Promise.resolve(e);if(workerpool.isMainThread){if(htmlLengthSyncThreshold>=0&&e.length>htmlLengthSyncThreshold)return _asyncSanitizeHtml(e,r);return Promise.resolve(_syncSanitizeHtml(e,r))}throw new Error("htmlSanitizer cannot be invoked from workers")}async function _asyncSanitizeHtml(e,r){const t=pool().exec("sanitizeHtml",[e,r]);updateWorkerMetrics();return _getSanitizeString(await t)}function _syncSanitizeHtml(e,r){return _getSanitizeString(sanitizeHtml(e,r))}function _getSanitizeString(e){if(null!=e.html)return e.html;if(e.error){if(e.details)loggers_1.logger.error(e.details.join(" | "));throw new __1.SystemError(e.error)}throw new __1.SystemError("sanitize html is expected to return a value")}exports.htmlSanitizer=htmlSanitizer;
//# sourceMappingURL=xss.js.map