/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getPeerCertificate=exports.getTlsConfig=exports.getInteropHttpsAgent=exports.registerTlsChangeListener=exports.loadExtraConfig=exports.initTlsLayer=void 0;const xtrem_config_1=require("@sage/xtrem-config"),fs=require("fs/promises"),_=require("lodash"),https=require("node:https"),fsp=require("path/posix"),tls=require("tls"),loggers_1=require("./loggers");let extraCaPem=[];function initTlsLayer(){const e=tls.createSecureContext;tls.createSecureContext=t=>{const r=e(t);return extraCaPem.forEach(e=>{r.context.addCACert(e.trim())}),r}}function addCaFile(e,t){if(e.startsWith("-----BEGIN "))return void loggers_1.logger.warn(`Ignoring CA file '${e}': it seems to be a PEM content`);if(t.includes(e))return void loggers_1.logger.warn(`Ignoring CA file '${e}': it has already been added`);t.push(e)}async function loadExtraConfig(){await loadExtraCaCert(),setHttpsAgent()}async function loadExtraCaCert(){const e=xtrem_config_1.ConfigManager.current.security?.tls,t=xtrem_config_1.ConfigManager.current.server,r=t?.sslShallowCopy,n=[];if(e?.extraCaFiles){const t=Array.isArray(e.extraCaFiles)?e.extraCaFiles:[e.extraCaFiles];n.push(...t)}if(r){if("string"==typeof r.ca)addCaFile(r.ca,n);if("string"==typeof r.cert){const e=fsp.dirname(r.cert);addCaFile(fsp.join(e,"ca.crt"),n)}}const i=[];if(n.length>0)await Promise.all(n.map(async e=>{i.push(...await loadPemFromFile(e))}));xtrem_config_1.ConfigManager.emitter.emit("extraCa",n);const s=n.map(e=>`'${e}'`);loggers_1.logger.info(`loading ${i.length} extra CA from: [${s}]`),extraCaPem=i}async function loadPemFromFile(e){try{return((await fs.readFile(e,{encoding:"ascii"})).replace(/\r\n/g,"\n").match(/-----BEGIN CERTIFICATE-----[A-Za-z0-9+/=\r\n]*-----END CERTIFICATE-----/g)||[]).map(e=>e.trim())}catch(t){return loggers_1.logger.error(`Cannot load CA '${e}': ${t.message}]`),[]}}function registerTlsChangeListener(e,t,r){const n=`Replacing secure context of the ${r} server`;xtrem_config_1.ConfigManager.emitter.addListener("tlsChange",r=>{const i=_.property(t)(xtrem_config_1.ConfigManager.current);if(i&&r===t)setTimeout(()=>{loggers_1.logger.info(n);try{e.setSecureContext(i),xtrem_config_1.ConfigManager.emitter.emit("tlsApply",t,i)}catch(e){loggers_1.logger.error(`[FAILED] ${n}: ${e.message}`)}},500)})}exports.initTlsLayer=initTlsLayer,exports.loadExtraConfig=loadExtraConfig,exports.registerTlsChangeListener=registerTlsChangeListener;let interopHttpsAgent=null;function getInteropHttpsAgent(){return interopHttpsAgent}function setHttpsAgent(){const e=getTlsConfig();if(interopHttpsAgent=null,e.ca&&e.cert&&e.key)interopHttpsAgent=new https.Agent(e)}function getTlsConfig(){const e=xtrem_config_1.ConfigManager.current.server;if(!e?.ssl)return{};return{ca:e.ssl.ca,cert:e.ssl.cert,key:e.ssl.key}}function isTlsSocket(e){return void 0!==e.getPeerCertificate}function getPeerCertificate(e){if(!isTlsSocket(e.socket))return null;return e.socket.getPeerCertificate()}exports.getInteropHttpsAgent=getInteropHttpsAgent,exports.getTlsConfig=getTlsConfig,exports.getPeerCertificate=getPeerCertificate;
//# sourceMappingURL=tls.js.map