/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.setup=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),_=require("lodash"),context_vault_1=require("../runtime/context-vault"),loggers_1=require("./loggers"),tls_1=require("./tls");let initialized=false;async function setup(){if(null==xtrem_config_1.ConfigManager.current)throw new Error("Config must be loaded first");if(initialized)return;initialized=true,await asyncLoadSecret(xtrem_config_1.ConfigManager.current),await(0,tls_1.loadExtraConfig)(),loggers_1.logger.info("Initializing security layer..."),xtrem_config_1.ConfigManager.emitter.addListener("loaded",()=>{asyncLoadSecret(xtrem_config_1.ConfigManager.current).then(()=>(0,tls_1.loadExtraConfig)()).catch(e=>loggers_1.logger.error(e))}),(0,tls_1.initTlsLayer)(),loggers_1.logger.info("Security layer initialized")}function collectSecrets(e,t,r){_.forIn(e,(i,o)=>{if("string"==typeof i){if(i.startsWith("@secret/"))t.push({obj:e,key:o,placeholder:i,path:[...r,o]})}else if(_.isArray(i))i.forEach((e,i)=>{if(_.isObject(e))collectSecrets(e,t,[...r,o,`[${i}]`])});else if(_.isObject(i))collectSecrets(i,t,[...r,o])})}async function asyncLoadSecret(e){const t=[];collectSecrets(e,t,[]),await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async e=>{const{obj:t,key:r,placeholder:i,path:o}=e;loggers_1.logger.info(`Loading secret for '${o.join(".")}' with placeholder '${i}'`),t[r]=await context_vault_1.ContextVault.getConfigSecretValue(i)})}exports.setup=setup;
//# sourceMappingURL=loader.js.map