/** @ignore */ /** */
import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
import { Maybe } from '@sage/xtrem-shared';
import { Property } from '../properties';
import { SqlConverter, Table } from '../sql';
import { NodeFactory } from './node-factory';
export interface RetryOptions {
    maxTries: number;
    delayBeforeRetry: number;
    message?: string;
    onError?: (error: Error) => void;
}
export declare function isCompound(val: AnyValue): val is AnyRecord;
export declare function tenantCondition(sqlConverter: SqlConverter, table: Table, alias: string, clauses: (string | undefined)[]): string;
/**
 * Returns the dependencies (as factory names) of a factory
 * @param factory the factory to analyze
 * @param allAvailableFactories the full list of available factories. This function will only return factories that belong to this list
 */
export declare function getFactoryDependsOn(factory: NodeFactory, allAvailableFactories: NodeFactory[]): string[];
/**
 * Use topoSort to order passed in factories based on their dependencies
 *
 * @param factories
 */
export declare function sortFactories(factories: NodeFactory[]): NodeFactory[];
/**
 * Returns the list of defaultable reference properties.
 * Reference properties are defaultable if they are either nullable or self-referencing.
 */
export declare function getDefaultableReferenceProperties(factory: NodeFactory, propertiesToUpdate?: Maybe<string[]>): Property[];
/**
 * Converts the data key to either snakeCase or camelCase
 * This function is used on the application when data is read from CSV files
 * and need to be loaded into postgres or if data is written into CSV
 *
 * @param data
 * @param conversion
 */
export declare function convertDataKey(data: AnyRecord[], conversion: 'snakeCase' | 'camelCase'): AnyRecord[];
/**
 * Returns the language code based on the locale supplied
 * @param locale
 */
export declare function getLanguageFromLocale(locale: string): string;
export declare const defaultAlphabet = " !\"#$%&()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[]^_abcdefghijklmnopqrstuvwxyz{|}~";
export declare function randomString(maxLength?: number, alphabet?: string): string;
/**
 * Re-tries the given function until it succeeds or a maximum number of tries are reached.
 * @param action - The action to be retried.
 * @param maxTries - The maximum number of tries to make. This includes the first try. Values less than 1 will try 1 time.
 * @param delayBeforeRetry - The delay in milliseconds between each successive retry.
 */
export declare function retry<T extends AnyValue>(action: () => AsyncResponse<T>, options?: RetryOptions): Promise<T>;
export declare function getServerUrl(path: string, params?: URLSearchParams): string;
//# sourceMappingURL=utils.d.ts.map