/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Transaction=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),node_state_1=require("../node-state"),core_hooks_1=require("./core-hooks"),debug_1=require("./debug"),loggers_1=require("./loggers");class Transaction{constructor(t,e={}){this.context=t,this._options=e,this._id=-1,this.skipUnsavedCheck=false,this.transientNodeStates={},this.readonlyNodeStates={},this.writableNodeStates={},this.#t=[],this.#e=new Map,this.debugId=debug_1.Debug.newId()}#t;#e;get id(){return(async()=>{if(this._id>=0)return this._id;const t=(await this.executeSql("select txid_current() as tid",[]))[0];return this._id=t?.tid,this._id})()}get isWritable(){return!this._options.isReadonly}get connection(){if(!this._connection)throw new Error("transaction is not isolated");return this._connection}get sqlPool(){return this.context.sqlPool}queueDeferredAction(t){this.#t.push(t)}async flushDeferredActions(){if(0===this.#t.length)return;await(0,xtrem_async_helper_1.asyncArray)(this.#t).forEach(t=>t()),this.#t.length=0}checkUnsaved(){if(this.skipUnsavedCheck)return;const isStatusUnsaved=t=>t!==node_state_1.StateStatus.updatable&&t!==node_state_1.StateStatus.constructed&&t!==node_state_1.StateStatus.stale,t=Object.keys(this.writableNodeStates).filter(t=>!this.writableNodeStates[t].isTransient&&!this.writableNodeStates[t].isOnlyForDefaultValues&&!this.writableNodeStates[t].isOnlyForDuplicate&&!this.writableNodeStates[t].isOnlyForLookup&&!this.writableNodeStates[t].factory.isContentAddressable&&isStatusUnsaved(this.writableNodeStates[t].status));if(t.length>0)throw new Error(`transaction error: modified nodes have not been saved: ${t.slice(0,10).join(", ")}`)}async executeSql(t,e,i){const s=this._connection??await this.sqlPool.allocConnection(this.context.originId);try{return await this.sqlPool.execute(s,t,e,i)}finally{if(!this._connection)this.sqlPool.releaseConnection(s)}}sqlIsolation(){switch(this._options.isolationLevel){case"high":return"SERIALIZABLE";case"medium":return"REPEATABLE READ";case"low":return"READ COMMITTED";default:throw new xtrem_shared_1.LogicError(`invalid isolation level: ${this._options.isolationLevel}`)}}sqlReadonlyOptions(){if(!this._options.isReadonly)return"";return"READ ONLY "+(this._options.isDeferrable?"DEFERRABLE":"")}async getSqlToSetSessionUser(){const t=null==this.context.tenantId||this.context.withoutTransactionUser?null:await this.context.user,e=await this.context.transactionUser,i=await this.context.loginUser||t,s=await core_hooks_1.CoreHooks.auditManager.isAuditEnabled(this.context);return`SELECT set_config('xtrem.transaction_user_id', '${e?._id||""}', true);\n        SELECT set_config('xtrem.user_email', '${t?.email}', true);\n        SELECT set_config('xtrem.login_email', '${i?.email}', true);\n        SELECT set_config('xtrem.is_audit_enabled', '${s?"TRUE":"FALSE"}', true);\n        `}async resetSessionUser(){await this.executeSql(await this.getSqlToSetSessionUser(),[])}async withCommit(t){if(this.context.managedExternal)return t();if(this._connection)throw new Error("nested _withCommit");loggers_1.loggers.sql.debug(()=>`BEGIN TRANSACTION: debugId=${this.debugId}, isWritable=${!this._options.isReadonly}`),this._connection=await this.sqlPool.allocConnection(this.context.originId);const e=this.context.isAutoCommit?"":`BEGIN TRANSACTION ISOLATION LEVEL ${this.sqlIsolation()} ${this.sqlReadonlyOptions()};\n        `;await this.sqlPool.execute(this._connection,`-- ** CONFIGURATION **\n${e}\nSELECT set_config('xtrem.origin_id', '${this.context.originId}', true);\n${await this.getSqlToSetSessionUser()}\n${this.context.disableAllCrudNotifications?"SELECT set_config('xtrem.notification.disable.ALL', 'true', true);":""}\n${this.context.disableTenantCrudNotifications?`SELECT set_config('xtrem.notification.disable.t_${this.context.tenantId}', 'true', true);`:""}\n`,[],{logLevel:"debug"});try{const e=await t();if(await this.context.flushDeferredSaves(),this.context.isAutoCommit);else if(this.context.mayCommit)this.checkUnsaved(),loggers_1.loggers.sql.debug(()=>`COMMIT TRANSACTION: debugId=${this.debugId}`),await this.flushDeferredActions(),await this.commit();else if(this.isWritable)loggers_1.loggers.sql.debug(()=>`ROLLBACK TRANSACTION: debugId=${this.debugId}`),await this.rollback();return e}catch(t){loggers_1.loggers.sql.debug(()=>`TRANSACTION FAILED debugId=${this.debugId}, stack=${t.stack}`);try{await this.rollback()}catch(t){loggers_1.loggers.sql.error(`ROLLBACK FAILED${t.stack}`)}throw t}}close(){if(!this._connection)return;this.sqlPool.releaseConnection(this._connection),this._connection=void 0,this._id=-1}async commit(){if(!this._connection)throw new Error("invalid commit: no connection");await this.context.notifyModifiedCachedCategories(),await this._connection.query("COMMIT"),await this.context.commitModifiedCachedCategories(),this.commitCache()}async rollback(){if(!this._connection)throw new Error("invalid commit: no connection");await this._connection.query("ROLLBACK"),this.context.rollbackModifiedCachedCategories(),this.rollbackCache()}createSqlReader(t,e,i){let s;const o=this._connection;let n;const read=async()=>{if(!s)s=o??await this.sqlPool.allocConnection(this.context.originId),n=this.sqlPool.createReader(s,t,await e,i);const r=await n.read();if(void 0===r)await stop();return r},stop=async()=>{if(s){if(o!==this._connection)throw new Error("connection mismatch in stop");if(!o)this.sqlPool.releaseConnection(s);s=void 0}if(n)await n.stop()};return new xtrem_async_helper_1.AsyncGenericReader({read,stop})}static markStatesAsStale(t){Object.values(t).forEach(t=>{t.status=node_state_1.StateStatus.stale})}static revertStatesToThunk(t){Object.values(t).forEach(t=>{t.isThunk=true,t.references.clear(),t.referenceArrays.clear(),t.collections.clear()})}getFactoryTick(t){return this.#e.get(t.rootFactory)??0}incrementFactoryTick(t){this.#e.set(t.rootFactory,this.getFactoryTick(t)+1),t.vitalProperties.forEach(t=>{this.incrementFactoryTick(t.targetFactory)})}rollbackCache(){Transaction.markStatesAsStale(this.readonlyNodeStates),Transaction.markStatesAsStale(this.writableNodeStates),this.readonlyNodeStates={},this.writableNodeStates={}}commitCache(){const t=this.context.pooledTransaction;if(t===this)throw new xtrem_shared_1.LogicError("cannot call commitCache on pooled transaction");if(t)Transaction.revertStatesToThunk(this.readonlyNodeStates),Transaction.revertStatesToThunk(this.writableNodeStates),this.readonlyNodeStates={},this.writableNodeStates={}}}exports.Transaction=Transaction;
//# sourceMappingURL=transaction.js.map