/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.friendlyOperationSignature=exports.ensureNoMultipleUniqueIndexes=exports.getPropertySchemaDescription=exports.getSchemaDescription=exports.setChildFactoriesTable=exports.arraysAreEqual=exports.sameIndexProperties=exports.friendlyJsonParse=void 0;const json5=require("json5"),_=require("lodash"),loggers_1=require("./loggers"),logger=loggers_1.loggers.nodeFactory;function friendlyJsonParse(e){return!/^[\s\n\r]*{[\s\n\r]*["]/.test(e)?json5.parse(e):JSON.parse(e)}function sameIndexProperties(e,r){const t=Object.keys(e.orderBy),n=Object.keys(r.orderBy);return t.every(e=>n.includes(e))&&n.every(e=>t.includes(e))}function arraysAreEqual(e,r){if(e.length!==r.length)return false;return e.every((e,t)=>e===r[t])}function setChildFactoriesTable(e){if(e.decorators.childFactories)e.decorators.childFactories.forEach(r=>{r.table=e.table,setChildFactoriesTable(r)}),e.decorators.childFactories=void 0}function getSchemaDescription(e,r){const t=_.kebabCase(e).replace(/-/g," "),n=`${t[0].toUpperCase()}${t.substr(1)}`;return r?`${n} (${r})`:n}function getPropertySchemaDescription(e){return getSchemaDescription(e.name,e.columnName)}function ensureNoMultipleUniqueIndexes(e){if(!e.isSetupNode)return;if(null==e.indexes||"sql"!==e.storage)return;const r=e.indexes.filter(e=>e.isUnique&&!!e.name);if(r.length<=1)return;const indexAsString=e=>`${e.isNaturalKey?"NaturalKey":e.name}(${Object.keys(e.orderBy).join(",")})`;r.forEach((t,n)=>{for(let s=n+1;s<r.length;s++){const n=r[s],a=Object.keys(t.orderBy),o=Object.keys(n.orderBy),i=_.difference(a,o),c=_.difference(o,a);if(i.length>0&&c.length>0)logger.error(`${e.name} : multiple unique indexes are forbidden for setup nodes. (${indexAsString(t)} / ${indexAsString(n)})`)}})}function makeFriendlyParameter(e){if("string"==typeof e)return e;switch(e.type){case"object":return{...e,properties:_.mapValues(e.properties,e=>makeFriendlyParameter(e))};case"array":return{...e,item:makeFriendlyParameter(e.item)};case"reference":case"instance":return{...e,node:e.node().name};default:return{...e,dataType:e.dataType?e.dataType().name:void 0}}}function friendlyOperationSignature(e){return{parameters:e.parameters.map(e=>makeFriendlyParameter(e)),return:makeFriendlyParameter(e.return)}}exports.friendlyJsonParse=friendlyJsonParse,exports.sameIndexProperties=sameIndexProperties,exports.arraysAreEqual=arraysAreEqual,exports.setChildFactoriesTable=setChildFactoriesTable,exports.getSchemaDescription=getSchemaDescription,exports.getPropertySchemaDescription=getPropertySchemaDescription,exports.ensureNoMultipleUniqueIndexes=ensureNoMultipleUniqueIndexes,exports.friendlyOperationSignature=friendlyOperationSignature;
//# sourceMappingURL=node-factory-utils.js.map