/** @ignore */ /** */
import { AnyRecord, AnyValue } from '@sage/xtrem-async-helper';
import { MessageListener, NodeDecorator, NodeExtensionDecorator, NotificationListener, PlainOperationDecorator } from '../decorators';
import { ForeignNodeProperty, ReferenceProperty } from '../properties';
import { Node } from '../ts-api';
import { NodeFactory } from './node-factory';
import { PropertyDecorator } from './property';
export interface ReversePropertyStruct {
    prop: ForeignNodeProperty;
    join: AnyRecord;
}
export interface FactoryLinkedList {
    previousLink?: FactoryLinkedList;
    targetFactory: NodeFactory;
    property: ReferenceProperty;
}
export interface FactoryNodeDecorator extends NodeDecorator {
    readonly name: string;
    baseNode?: FactoryNodeDecorator;
}
export interface FactoryExtensionDecorator extends NodeDecorator {
    readonly name: string;
    baseNode?: FactoryNodeDecorator;
}
type FilterBase<Base, Condition> = {
    [Key in keyof Base]: Base[Key] extends Condition ? Key : never;
};
type FilterKeys<Base, Condition> = NonNullable<FilterBase<Base, Condition>[keyof Base]>;
export interface NodeNamedExtensionDecorator extends NodeExtensionDecorator<Node> {
    name: string;
}
export interface FactoryExtensionDecorators {
    nodeExtension: NodeNamedExtensionDecorator;
    superDecorators?: FactoryDecorators;
    properties: PropertyDecorator[];
    mutations: PlainOperationDecorator[];
    queries: PlainOperationDecorator[];
    notificationListeners: NotificationListener[];
    messageListeners: MessageListener[];
}
type FactoryDecoratorsArrayKeys = FilterKeys<FactoryDecorators, any[]>;
type FactoryExtensionDecoratorsArrayKeys = FilterKeys<FactoryExtensionDecorators, any[]>;
type NodeFactoryDecoratorsDictKeys = FilterKeys<NodeFactory, any[]>;
export type FactoryDecoratorsDictArrayKeys = NonNullable<(FactoryDecoratorsArrayKeys | FactoryExtensionDecoratorsArrayKeys) & NodeFactoryDecoratorsDictKeys>;
export interface ErrorParameters {
    key: string;
    message: string;
    data?: object | AnyValue[];
    innerError?: Error;
}
export {};
//# sourceMappingURL=node-factory-types.d.ts.map