/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.monitoredFunnel=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),prom_client_1=require("prom-client"),custom_metrics_1=require("../metrics/prometheus/custom-metrics"),funnelMetricsEnabled=custom_metrics_1.allMetricsEnabled||(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_FUNNEL_METRICS_ENABLED),monitoredFunnelMap=(0,xtrem_shared_1.createDictionary)(),ensureInitialized=(()=>{let e;return()=>{if(null!=e)return e;return e={highWaterMark:new prom_client_1.Gauge({name:"xtrem_funnel_queue_hwm",help:"The high water mark of the funnel queues",labelNames:["funnelName"],collect(){Object.values(monitoredFunnelMap).forEach(n=>{const r=n.funnelName;this.set({funnelName:r},n.funnel.highWaterMark),e?.length.set({funnelName:r},n.highWaterMark),e?.ratio.set({funnelName:r},n.highWaterMark/n.funnel.capacity),n.highWaterMark=0})}}),length:new prom_client_1.Gauge({name:"xtrem_funnel_queue_length",help:"The length of the funnel queues",labelNames:["funnelName"]}),ratio:new prom_client_1.Gauge({name:"xtrem_funnel_queue_ratio",help:"The usage ratio of the funnel queues (length / max capacity)",labelNames:["funnelName"]})},e}})();function monitoredFunnel(e,n=1){if(!funnelMetricsEnabled)return(0,xtrem_async_helper_1.funnel)(n);ensureInitialized();const r=(0,xtrem_async_helper_1.funnel)(n,()=>{const n=monitoredFunnelMap[e],r=n.funnel.length;if(r>n.highWaterMark)n.highWaterMark=r});return monitoredFunnelMap[e]={funnelName:e,funnel:r,highWaterMark:0},r}exports.monitoredFunnel=monitoredFunnel;
//# sourceMappingURL=monitored-funnel.js.map