/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.Context=exports.personaCookieDefinition=exports.adminDemoPersona=exports.adminDemoPersonaEmail=exports.supportReadonlyUserEmail=exports.supportUserEmail=exports.rootUserEmail=exports.ContextGetConfigurationKeyEnum=exports.PackAllocationStatusEnum=exports.standardOperations=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_i18n_1=require("@sage/xtrem-i18n"),xtrem_log_1=require("@sage/xtrem-log"),xtrem_postgres_1=require("@sage/xtrem-postgres"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_ts_to_sql_1=require("@sage/xtrem-ts-to-sql"),events_1=require("events"),graphql_1=require("graphql"),_=require("lodash"),fsp=require("path"),service_option_manager_1=require("../application/service-option-manager"),index_1=require("../cache/index"),concurrency_utils_1=require("../concurrency-utils"),access_rights_1=require("../graphql/security/access-rights"),request_1=require("../graphql/utils/request"),request_2=require("../http/request"),node_state_1=require("../node-state"),state_intern_1=require("../node-state/state-intern"),sql_1=require("../sql"),sql_select_1=require("../sql/mapper/sql-select"),pubsub_1=require("../sql/pubsub"),ts_api_1=require("../ts-api"),array_utils_1=require("./array-utils"),collation_cache_1=require("./collation-cache"),configuration_service_1=require("./configuration-service"),container_manager_1=require("./container-manager"),context_natural_key_converter_1=require("./context-natural-key-converter"),context_vault_1=require("./context-vault"),debug_1=require("./debug"),introspection_1=require("./introspection"),loggers_1=require("./loggers"),running_context_1=require("./running-context"),transaction_1=require("./transaction"),utils_1=require("./utils");var PackAllocationStatusEnum,NotificationTopic,ContextGetConfigurationKeyEnum;exports.standardOperations=["create","update","delete","read","lookup","import"],function(e){e[e.off=1]="off",e[e.preparing=2]="preparing",e[e.on=3]="on"}(PackAllocationStatusEnum||(exports.PackAllocationStatusEnum=PackAllocationStatusEnum={})),function(e){e.invalidateCategoryCache="invalidateCategoryCache"}(NotificationTopic||(NotificationTopic={})),function(e){e[e.serviceOptionsLevel=0]="serviceOptionsLevel"}(ContextGetConfigurationKeyEnum||(exports.ContextGetConfigurationKeyEnum=ContextGetConfigurationKeyEnum={})),exports.rootUserEmail="root@localhost.domain",exports.supportUserEmail="support@localhost.domain",exports.supportReadonlyUserEmail="support.readonly@localhost.domain",exports.adminDemoPersonaEmail="admin.persona@localhost.domain",exports.adminDemoPersona={_id:1e11,email:exports.adminDemoPersonaEmail,userName:exports.adminDemoPersonaEmail,firstName:"Admin",lastName:"Persona",isActive:true,isAdministrator:true,isDemoPersona:true};const personaCookieDefinition=(e,t)=>({name:`xtrem_${e}_persona`,options:{httpOnly:true,sameSite:"lax",secure:t}});function forwardedFromSecure(e){const t=e.headers?.["x-forwarded-proto"],s=Array.isArray(t)?t[0]:t;return null!=s&&/^https$/i.test(s)}function ensureUserName(e){if(e.email&&!e.userName)e.userName=e.email;return e}function isValidUser(e){return!!(e&&e._id&&e.email)}function userDetails(e){return e?`${e._id}/'${e.email}'`:"undefined/undefined"}exports.personaCookieDefinition=personaCookieDefinition;class Context extends events_1.EventEmitter{#e;#t;#s;#i;#r;#a;#n;#o;get source(){return this.#n||"internal"}set source(e){this.#n=e}get isIsolated(){return this.#o}get noLazyLoading(){return!!this.options.noLazyLoading}#l;get withoutTransactionUser(){if(null!=this.#l)return this.#l;return this.#l=!!this.options.withoutTransactionUser,this.#l}#c;#h;#u;#g;static{this._subscribedToCacheNotifications=false}#d;#p;#m;#f;constructor(e,t,s){super(),this.application=e,this.options=t,this.#e={},this.#t=null,this.#s=null,this.#a={_id:0,email:""},this.globals={},this.constants={},this.customFields={},this._duplicatedLoggedMessages={},this._nodesWithDeferredSave=[],this._contextValues={},this._lastTransientId=-1e9,this._allocateExternalIds=false,this._lastExternalTransientId=0,this.disableGetPropertyValueErrorLogger=false,this.processLocalizedTextAsJson=false,this._inCsvLoading=false,this.nestedReadonlyScopes=0,this.nestedTransientScopes=0,this.children=[],this.vault=new context_vault_1.ContextVault(this),this.sqlFunctionCache={},this.#p={},this.mappedIds={},this.#m=0,this._allowedAccessCodes={},this._computingAccessRights=false,this.#_=new Map,this.#y=new Map,this.diagnosesPrefixes=[],this._diagnoses=[],this._severity=xtrem_shared_1.ValidationSeverity.test,this.#x=[],this.#i=t.userEmail;const i=t.config&&Object.keys(t.config).length?{...xtrem_config_1.ConfigManager.current,...t.config}:xtrem_config_1.ConfigManager.current;if(this._config=i,this.managedExternal=!!i.storage.managedExternal,!this.managedExternal)if(!i.storage.sql)throw new Error("invalid config: sql config missing");if(this.#d=new index_1.MemoryCache(s||"*","context"),process.env.MODULE_DIR=this.application.name,this.apiApplication={id:i.applicationId,name:i.applicationName},this._config=i,this.#n=this.options.source||"internal",this.#o=t.isIsolated||false,this.pooledTransaction=new transaction_1.Transaction(this,{isReadonly:true}),this.debugId=debug_1.Debug.newId(),this.request=t.request||{},this.response=t.response||{},this.testMode=!!t.testMode,this.testLayers=t.testLayers,this.testNowMock=t.testNowMock,this.testMode)this.testConfig=t.testConfig;if(t.testActiveServiceOptions)this.activateTestServiceOptions(t.testActiveServiceOptions);const r=t.parent;if(r)this.#c=r.tenantId,this._allowedAccessCodes=r._allowedAccessCodes,this._computingAccessRights=r._computingAccessRights,this._contextValues=r._contextValues,this.#i=r.#i,this.request=r.request,this.response=r.response,this.debugPath=`${r.debugPath}/${this.debugId}`;else this.debugPath=`${this.debugId}`,this.#c=s;if(this.#c&&this.options.unsafeApplyToAllTenants)throw new xtrem_shared_1.SystemError("Cannot create a context where unsafeApplyToAllTenants is true and a tenantId is supplied");if(t.isSystem)this.#i=exports.rootUserEmail;if(this.isHttp()){const e=this.response.locals;if(e.contextValues)this._contextValues=e.contextValues;if(e.auth?.login===exports.rootUserEmail)throw new xtrem_shared_1.SystemError(`Cannot use ${exports.rootUserEmail} as login user`);this.#e=e.auth||{}}else if(t.auth)this.#e=t.auth||{};if(!this.managedExternal){if(this.#e.persona&&!this.#e.login)throw new xtrem_shared_1.SystemError(`Cannot initialize context with the persona '${this.#e.persona}' but no login user`);const e=this.#a;if(e.email=this.#i||this.#e.login||"",!e.email){const t="The context must be initialized with a non empty user email",s=`Please consider using application.asRoot.withXxxxContext methods for internal system contexts that ${null==this.#c?"do not provide a tenant Id and/or ":""}do not require an authenticated user.`;if(loggers_1.loggers.runtime.error(`${t} and should not rely on development config, isHttp=${this.isHttp()}. ${s}`),(0,xtrem_shared_1.isDevelopmentConfig)(i))throw new xtrem_shared_1.SystemError(t);else e.email=exports.rootUserEmail}if(!xtrem_shared_1.validator.isEmail(e.email))throw new xtrem_shared_1.SystemError(`context must be initialized with a valid user email. Got '${e.email}' userEmail=${this.#i} isHttp=${this.isHttp()}`)}if(null==this._contextValues)this._contextValues={};if(t.contextValues)this._contextValues={...this._contextValues,...t.contextValues};this.logger=xtrem_log_1.Logger.getLogger(fsp.join(this.application.dir,"package.json"),"context"),loggers_1.loggers.runtime.verbose(()=>`Create context from config with email '${this.options.userEmail||i.email}', tenantId '${this.#c}', loginUser=${userDetails(this.#s)}`)}async init(){const{signal:e}=this.options;if(e){if(e.aborted)throw new xtrem_shared_1.SystemError("cannot init the context: signal has been aborted");if(null==e.onabort)e.onabort=()=>{this.logger.warn(`abort signal has been notified, hint: [${this.getRequestHint()}]`),e.onabort=null}}if(await this.setDefaultLocale(),await this.setCurrentLocale(this.options.locale||"base"),xtrem_config_1.ConfigManager.current.storage?.managedExternal&&!this.options.withoutSqlConnection&&!this.options.skipManagedExternalInit&&null==this.#h)this.#h=await this.activeServiceOptions;if(this.options.bypassFrozen&&!this.options.testMode)throw new xtrem_shared_1.LogicError("cannot create context: bypassFrozen option can only be set in test mode");return this}static create(e,t,s){if(t.signal?.aborted)throw new xtrem_shared_1.SystemError("cannot create the context: signal has been aborted");return new Context(e,t,s).init()}async close(){if(await(0,xtrem_async_helper_1.asyncArray)(this.children.slice()).forEach(e=>e.close()),0!==this.children.length)throw new xtrem_shared_1.LogicError("some children not deleted");if(this.isolatedTransaction)this.isolatedTransaction.close(),this.isolatedTransaction=void 0;if(this.options.parent){const e=this.options.parent.children;e.splice(e.indexOf(this),1),this.options.parent=void 0}this.logSqlSummary(),this.logIgnoredDuplicateMessages(),this.emit("closed")}get schemaName(){return this.application.schemaName}get disableAllCrudNotifications(){return!!this.options.disableAllCrudNotifications}get disableTenantCrudNotifications(){return!!this.options.disableTenantCrudNotifications}get bypassFrozen(){return!!this.options.bypassFrozen}get withoutSqlConnection(){return!!this.options.withoutSqlConnection}queueDeferredSave(e){const t=this._nodesWithDeferredSave.some(t=>t.$.state.interningKeyValues[0]===e.$.state.interningKeyValues[0]);if(this.logger.verbose(()=>`Deferring save of node ${e.$.factory.name}.${e._id}${t?" - already registered":""}`),!t)this._nodesWithDeferredSave.push(e)}async flushDeferredSaves(){let e=0;for(;this._nodesWithDeferredSave.length>0;){if(e+=1,e>50)throw new xtrem_shared_1.SystemError("Loop detected in deferred saves");const t=[...this._nodesWithDeferredSave];this._nodesWithDeferredSave.length=0,await(0,xtrem_async_helper_1.asyncArray)(t).forEach(async e=>{this.logger.verbose(()=>`Saving deferred node ${e.$.factory.name}.${e._id}`),await e.$.save()})}}get nodesWithDeferredSave(){return this._nodesWithDeferredSave}async keepEventLoopHealthy(){if(this.#m+=1,this.#m%2e3==0)this.checkNotAborted("Keep event loop healthy"),await new Promise(setImmediate);if(this.#m%1e5==0)this._logDetailsForExpensiveContext()}getRequestHint(){const{request:e}=this;if(!e)return null;return`${e.headers?.["xtrem-graphql-fetcher"]?"graphiql:":""}${e.body?(0,request_1.getGraphQlHint)(e)??"":""}`}_logDetailsForExpensiveContext(){const e=this.options.description;if(!e)return;this.logger.warn(`The context '${e()}' is running an expensive operation`)}businessRuleError(e){return new xtrem_shared_1.BusinessRuleError(this.localize(e.key,e.message,e.data||{}),e.innerError,e.diagnoses)}integrityConstraintError(e){const[t,s]=(/\((.*)\)=\((.*)\)/.exec(e.detail||"")||[]).slice(1).map(e=>e.split(", "));if(!t)throw e;if("_tenant_id"===t[0])t.shift(),s.shift();const i=e.table,r=i?this.application.getFactoryByTableName(i):void 0,a=r?.getTableColumns(),n=t.filter(e=>!!a?.find(t=>t.columnName===e)?.propertyName).map((e,t)=>({columnName:e,value:s[t],propertyName:a?.find(t=>t.columnName===e)?.propertyName})),[o,l,c]=(()=>{if("23505"===e.code)return["@sage/xtrem-core/unique-index-violation","@sage/xtrem-core/unique-index-violation","The operation failed because the record already exists."];return["@sage/xtrem-core/field-integrity-constraint-violation","@sage/xtrem-core/integrity-constraint-violation","The database rejected this operation."]})(),h=n.length?n.map(e=>{const t={message:this.localize(o,c),path:[]};if(e.propertyName)t.path?.push(e.propertyName);return t}):void 0;throw this.businessRuleError({key:l,message:c,innerError:e,diagnoses:h})}shouldIgnoreDuplicateLogs(e){const t=(this._duplicatedLoggedMessages[e]||0)+1;return this._duplicatedLoggedMessages[e]=t,t>1}authorizationError(e){return new xtrem_shared_1.AuthorizationError(this.localize(e.key,e.message,e.data||{}),e.innerError)}dataInputError(e){return new xtrem_shared_1.DataInputError(this.localize(e.key,e.message,e.data||{}),e.innerError)}isSecure(){const{request:e}=this,{connection:t}=e;return e.secure||forwardedFromSecure(e)||!!t&&"authorized"in t}isHttp(){const e=this.response;return"ServerResponse"===e?.constructor?.name&&e.locals&&"function"==typeof e.cookie}static async subscribeToCacheNotifications(e){if(!Context._subscribedToCacheNotifications)Context._subscribedToCacheNotifications=true,await pubsub_1.PubSub.subscribe(NotificationTopic.invalidateCategoryCache,Context.onInvalidateCategoryCache(e))}#w;get cloudflareRayID(){if(null!=this.#w)return this.#w;this.#w="";const e=this.request.headers;if(e){let t=e["cf-ray"];if(Array.isArray(t))t=t[0];if(t&&"string"==typeof t){if(!/^[0-9a-zA-Z-]{8,64}$/.test(t))return"";return this.#w=t,t}}const t=this.getContextValue("originId");if(t?.startsWith("cloudflare:")&&t.length>10)this.#w=t.slice(10);return this.#w}get requestSource(){if(this.cloudflareRayID)return"cloudflare";return["graphql","rest"].includes(this.source)?this.source:"container"}get customerRequestId(){return this.cloudflareRayID?this.cloudflareRayID:`${container_manager_1.ContainerManager.containerId}-${this.debugId}`}get clusterId(){return this._config.clusterId}get originId(){return this.getContextValue("originId")||`${this.requestSource}:${this.customerRequestId}`}get isAborted(){return!!this.options.signal?.aborted}checkNotAborted(e){if(this.isAborted)throw new xtrem_shared_1.SystemError(`${e}: context has been aborted`)}get transaction(){return this.checkNotAborted("cannot get the current transaction"),this.isolatedTransaction||this.pooledTransaction}get tenantId(){return this.#c}get unsafeApplyToAllTenants(){return!!this.options.unsafeApplyToAllTenants}resetUsers(){this.#a={_id:0,email:""},this.#s=null,this.#t=null;const e=this.options.config&&Object.keys(this.options.config).length?{...xtrem_config_1.ConfigManager.current,...this.options.config}:xtrem_config_1.ConfigManager.current;if(!this.managedExternal){if(this.#e.persona&&!this.#e.login)throw new xtrem_shared_1.SystemError(`Cannot initialize context with the persona '${this.#e.persona}' but no login user`);const t=this.#a;if(t.email=this.#i||this.#e.login||"",!t.email)if((0,xtrem_shared_1.isDevelopmentConfig)(e))t.email=this._config.email||this._config.user||"";if(!xtrem_shared_1.validator.isEmail(t.email))loggers_1.loggers.runtime.error(`context must be initialized with a valid user email. Got '${t.email}' userEmail=${this.#i} isHttp=${this.isHttp()}`)}}async setTenantId(e){if(this.#a.email!==exports.rootUserEmail)throw new xtrem_shared_1.SystemError("Cannot set a tenantId in a non root context");if("graphql"===this.source)throw new xtrem_shared_1.SystemError("Cannot set the tenantId in a graphQL context");if(null!=e&&this.unsafeApplyToAllTenants)throw new xtrem_shared_1.SystemError("Cannot set a tenantId when unsafeApplyToAllTenants is true");if(this.#c=e,e&&this.isolatedTransaction)this.#l=false,this.resetUsers(),await this.transaction.resetSessionUser();this.#d=new index_1.MemoryCache(e||"*","context")}get collectedDependencyPaths(){return this._collectedDependencyPaths}collectDependencyPaths(e,t){const s=new sql_1.SqlConverter(this,e.factory),i=[];this._collectedDependencyPaths=i;try{s.convertFunction(e[t])}finally{this._collectedDependencyPaths=void 0}return i}getActivePackageNames(){return this.application.packageManager.getActivePackageNames(this)}async isAuthorized(e,t){if(!Context.accessRightsManager)throw new Error("Access rights manager must be instantiated before calling isAuthorized");return"authorized"===(await Context.accessRightsManager.getUserAccessFor(this,e.node.name,t)).status}getActivities(){return this.application.activityManager.getActivities()}isNodeAccessControlled(e){return this.application.activityManager.isNodeAccessControlled(e)}async isPackageEnabled(e){return null==e?true:(await this.application.packageManager.getActivePackageNames(this)).includes(e)}supportsPersona(){return Context.accessRightsManager.supportsPersona(this)}async isDemoPersona(e){try{if(!await this.supportsPersona())return false;return!!e?.isDemoPersona}catch(e){if("test"===this.application.applicationType)return loggers_1.loggers.runtime.warn(`cannot get 'isDemoPersona' property of test application ${this.application.name} user email ${this.#a.email}: ${e.stack}`),false;throw e}}get activeServiceOptions(){return this.serviceOptionManager.getEnabledServiceOptions(this)}async notifyInvalidateCategory(e){loggers_1.loggers.globalCache.verbose(()=>`Broadcast cache RESET tenantId:${this.tenantId}, category:${e}`),await pubsub_1.PubSub.publish(this,NotificationTopic.invalidateCategoryCache,{tenantId:this.tenantId,category:e},{excludeSelf:true})}static onInvalidateCategoryCache(e){return async t=>{loggers_1.loggers.globalCache.verbose(()=>`Received in-memory cache RESET event: ${JSON.stringify(t)}`),await e.asRoot.withCommittedContext(t.tenantId,e=>e.application.globalCache.invalidateCategory(e,t.category,{skipNotify:true}),{description:()=>`Invalidate category cache ${t.category}`})}}isEnabledByServiceOptions(e){if(!e)return false;return(0,xtrem_async_helper_1.asyncArray)(e.serviceOptions).every(e=>this.isServiceOptionEnabled(e))}isServiceOptionActiveSync(e){return!!this.#h?.some(t=>t.name===e.name)}adjustLastExternalId(e){if(e<this._lastExternalTransientId)this._lastExternalTransientId=e}allocateTransientId(){if(this._allocateExternalIds)return this._lastExternalTransientId-=1,this._lastExternalTransientId;return this._lastTransientId-=1,this._lastTransientId}get loginUser(){return(async()=>(await this.resolveLoginUser(),this.#s))()}get transactionUser(){return(async()=>{if(!this.#c||this.withoutTransactionUser)return null;const e=await this.user;if(null==e)return null;return await this.loginUser||e})()}async resolveLoginUser(){if(!this.#e?.login)return;if(isValidUser(this.#s))return;if(isValidUser(this.#a)&&this.#a.email===this.#e.login)this.#s={...this.#a};else this.#s=await Context.accessRightsManager.getUser(this,this.#e.login);const e=this.#e?.auth0,t=e?.split("|")[0];if("api"===t&&!this.#s.isApiUser)throw new xtrem_shared_1.SystemError(`api token requires an api login user, got '${this.#s.email}'`);else if("api"!==t&&this.#s.isApiUser)throw new xtrem_shared_1.SystemError(`login user '${this.#s.email}' requires an api token`);if(!this.#s.isActive)throw new xtrem_shared_1.SystemError(`cannot connect with an inactive login user '${this.#s.email}'`);if(await this.isDemoPersona(this.#s))throw new xtrem_shared_1.SystemError(`cannot use the persona '${this.#s.email}' as login user`);ensureUserName(this.#s)}async verifiedUser(){if(this.#a.email!==exports.rootUserEmail&&await this.isDemoPersona(this.#a)&&!isValidUser(this.#s))throw new xtrem_shared_1.SystemError(`cannot use the persona '${this.#a.email}' without a login user`);return ensureUserName(this.#a)}async resolvePersonaUser(e){if(!this.#e?.login)return;if(!e?.force&&isValidUser(this.#t)||!await this.supportsPersona())return;let t="";const s=this.#s?.isAdministrator||this.#s?.isFirstAdminUser,i=await Context.accessRightsManager.getDemoPersonas(this);if(this.#e.persona===exports.adminDemoPersonaEmail&&!i.find(e=>e.email===exports.adminDemoPersonaEmail||e.isAdministrator||e.isFirstAdminUser))throw t=`The login id '${this.#s?.email}' does not have the '${this.#e.persona}' persona`,new xtrem_shared_1.SecurityError(`${t}, and no 'administrator' persona is available for this user.`);const r=this.#e.persona&&await Context.accessRightsManager.getPersonaUser(this,this.#e.persona)||(await Context.accessRightsManager.getDemoPersonas(this))[0];if(!r){if(this.#e.persona)t=`persona ${this.#e.persona} not found for login id ${this.#s?._id}`;else t=`cannot assign a default persona to login id ${this.#s?._id}`;throw new xtrem_shared_1.SystemError(`${t}, and no ${s?"admin":""} persona is available`)}else if(r.isApiUser)throw new xtrem_shared_1.SystemError(`persona '${r.email}' cannot be an api user`);if(this.#t=r,this.#a=r,this.isHttp())this.setPersonaCookie(r.email)}setPersonaCookie(e){if(!this.tenantId)return;const t=(0,exports.personaCookieDefinition)(this.tenantId,this.isSecure());this.response.cookie(t.name,e,t.options)}async setDemoPersona(e){if(!this.#e?.persona&&!this.#e?.login)return false;if(this.#e.persona=e,await this.resolvePersonaUser({force:true}),this.isHttp())return this.setPersonaCookie(e),true;return false}get rootUser(){return Context.accessRightsManager.getUser(this,exports.rootUserEmail)}get userId(){return this.#a._id}get userIp(){if(!this.#r)this.#r=this.request?.ip||running_context_1.globalRunningContext.natIpAddress;return this.#r}get user(){return(async()=>{if(!this.#a)return null;if(!Context.accessRightsManager)throw new Error("Access rights manager must be instantiated before accessing user property");if(!this.managedExternal)if(isValidUser(this.#a)&&isValidUser(this.#s))return ensureUserName(this.#a);await this.resolveLoginUser();let e=this.#a.email||this.#a.userName||this.#s?.email||this._config.email||this._config.user;if(await this.resolvePersonaUser(),isValidUser(this.#t))return this.verifiedUser();if(!this.managedExternal&&!e)e=exports.rootUserEmail;if(isValidUser(this.#a)&&this.#a.userName)return this.verifiedUser();if(e){if(isValidUser(this.#s)&&this.#s.email===e)this.#a={...this.#s};if(this.#a=await Context.accessRightsManager.getUser(this,e),await this.isDemoPersona(this.#s))throw new xtrem_shared_1.SystemError(`cannot use the persona '${e}' as login user`)}if(!this.#a)throw new Error(`User not found for ${this._config.user?`username: ${this._config.user}, `:""}${this._config.email?`email: ${this._config.email}`:""}`);try{return await this.verifiedUser()}finally{loggers_1.loggers.runtime.debug(()=>`User initialized with '${this.#a.userName} [${this.#a.firstName}, ${this.#a.lastName}, ${this.#a.email}]'`)}})()}isMasterLocale(){return this.#u}get currentLocaleLanguage(){if(this._currentLocaleLanguage)return this._currentLocaleLanguage;return this._currentLocaleLanguage=(0,utils_1.getLanguageFromLocale)(this.currentLocale),this._currentLocaleLanguage}get currentLocale(){return this._currentLocale||"base"}async setCurrentLocale(e){try{this._currentLocaleLanguage=(0,utils_1.getLanguageFromLocale)(e),this._currentLocalizeLocale=(0,xtrem_i18n_1.getLocaleFromString)(e),this._currentLocale=e,this.#g=_.uniq([this.currentLocale,this.currentLocaleLanguage,this.defaultLanguage,"en"]),this.#u=null!=this.tenantId&&Context._localizationManager&&await Context.localizationManager.isMasterLocale(this)}catch(e){if(!this._currentLocale)this._currentLocale=this.defaultLocale;throw this._currentLocaleLanguage=(0,utils_1.getLanguageFromLocale)(this._currentLocale),this._currentLocalizeLocale=(0,xtrem_i18n_1.getLocaleFromString)(this._currentLocale),e}}async setTestLocale(e){const t="base"!==e?e:this.defaultLocale;await this.setCurrentLocale(t)}async setDefaultLocale(){if(this.options.withoutSqlConnection)return void(this._defaultLocale="base");try{if(null!=this.tenantId&&Context._localizationManager)this._defaultLocale=await Context.localizationManager.getDefaultTenantLocale(this)}catch(e){if(e.message===`relation "${this.schemaName}.locale" does not exist`);else throw e}if(!this._defaultLocale)this._defaultLocale="base";loggers_1.loggers.runtime.verbose(()=>`default locale: ${this._defaultLocale}`)}get defaultLocale(){return this._defaultLocale}get defaultLanguage(){if(this._defaultLocaleLanguage)return this._defaultLocaleLanguage;return this._defaultLocaleLanguage=(0,utils_1.getLanguageFromLocale)(this.defaultLocale),loggers_1.loggers.runtime.verbose(()=>`default language: ${this._defaultLocaleLanguage}`),this._defaultLocaleLanguage}get locales(){return this.#g}get collation(){if(this._collation)return this._collation;return this._collation=collation_cache_1.CollationCache.getCollation(this.currentLocale,this.currentLocaleLanguage),this._collation}static getLocalizedFallback(e){const t=e.split("/").pop()?.split("__")??[];if(t.length<3)return null;if("data_types"!==t[0]&&!t[1].startsWith("test_"))return null;return(0,xtrem_shared_1.titleCase)(t[5]||t[3]||t[1])}localize(e,t,s={},i=this._currentLocalizeLocale){try{return(0,xtrem_i18n_1.localizedText)(e,t,s,i)}catch(t){const s=Context.getLocalizedFallback(e);if(null==s)throw t;return s}}localizeEnumMember(e,t){try{return(0,xtrem_i18n_1.localizeEnumMember)(e,t,this._currentLocalizeLocale)}catch{return(0,xtrem_shared_1.titleCase)(t)}}get intern(){return this._intern=this._intern||new state_intern_1.StateIntern(this),this._intern}getContextValue(e){return this._contextValues[e]}get sqlPool(){if(this.managedExternal)throw new Error("Internal connection is not possible for externally managed applications");return sql_1.DatabaseManager.getPool(this._config.storage?.sql)}static{this._managers=[]}static addManager(e){this._managers.push(e)}static get managers(){return this._managers}static get accessRightsManager(){if(!this._accessRightsManager)throw new Error("Access rights manager is not registered");return this._accessRightsManager}static set accessRightsManager(e){this._accessRightsManager=e}static get localizationManager(){if(!this._localizationManager)throw new Error("Localization manager is not registered");return this._localizationManager}static set localizationManager(e){this.addManager(this._localizationManager=e)}get serviceOptionManager(){return this.application.serviceOptionManager}static get tenantManager(){if(!this._tenantManager)throw new Error("Tenant manager is not registered");return this._tenantManager}static set tenantManager(e){this.addManager(this._tenantManager=e)}static get dataSettingsManager(){if(!this._dataSettingsManager)throw new Error("Data settings manager is not registered");return this._dataSettingsManager}static set dataSettingsManager(e){this.addManager(this._dataSettingsManager=e)}static get notificationManager(){if(!this._notificationManager)throw new Error("Notification manager is not registered");return this._notificationManager}static set notificationManager(e){this._notificationManager=e}addRestrictedFilterDiagnose(e){this.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.warn,e,this.localize("@sage/xtrem-core/filter-property-unavailable-or-unauthorized","The property in the filter is unavailable or unauthorized.",{}))}addRestrictedOrderByDiagnose(e){this.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.warn,e,this.localize("@sage/xtrem-core/order-by-property-unavailable-or-unauthorized","The property in the sort order is unavailable or unauthorized.",{}))}addRestrictedPropertyDiagnose(e){this.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.error,e,this.localize("@sage/xtrem-core/property-unavailable","The property is unavailable.",{}))}isAccessCodeAvailable(e){return!e||Context.accessRightsManager.isAccessCodeAvailable(this,e)}setAllowedAccessCodes(e){try{this._computingAccessRights=true,this._allowedAccessCodes.site=e.sites,this._allowedAccessCodes.accessCode=e.accessCodes}finally{this._computingAccessRights=false}}getAllowedAccessCodes(e){if(this._computingAccessRights)return null;return this._allowedAccessCodes[e]||null}checkThatNodeOperationIsAuthorized(e,t){return access_rights_1.AccessRights.checkOperationAccessRight(this,{nodeName:e,operationName:t,isPropertyAccess:false})}get isWritable(){return this.transaction.isWritable}get isAutoCommit(){return!!this.options.isAutoCommit}#_;static{this.overallSqlExecutionCount=0}static canRelaxSqlInjectionTest(){const e=process.argv.slice(2).find(e=>"--"!==e)||"";if(/^(upgrade|tenant)$/.test(e))return true;const t=process.cwd();if(/xtrem-core|xtrem-system|xtrem-data-management|x3-/.test(t))return true;if(/xtrem-upgrade-/.test(t)&&"test"===e)return true;return false}static stripRaiseStatements(e){return e.replace(/\bRAISE( (DEBUG|LOG|INFO|NOTICE|WARNING|EXCEPTION))? '[^']+'/g,"")}static isSafe(e){let t=0;for(;;){if(t=e.indexOf("'",t),t<0)return true;const s=e.indexOf("'",t+1);if(xtrem_ts_to_sql_1.Converter.isSafeStringLiteral(e.substring(t+1,s)))t=s+1;else return false}}static preventSqlInjections(e){if(this.isSafe(e))return;if(/^NOTIFY[^']*'[^']*';$/.test(e))return;if(this.isSafe(this.stripRaiseStatements(e)))return;if(this.canRelaxSqlInjectionTest())console.log(`[SECURITY] Detected risk of SQL injection: ${e}`);else throw new xtrem_shared_1.SecurityError(`Detected risk of SQL injection: ${e}`)}logSql(e,t){if("verbose"!==loggers_1.loggers.performance.logLevel&&"debug"!==loggers_1.loggers.performance.logLevel)return;(async()=>{const s=`${e}, ${JSON.stringify(await t)}`;if(this.#_.has(s)){const e=(this.#_.get(s)||0)+1;this.#_.set(s,e),loggers_1.loggers.performance.debug(()=>`Execution ${e} of sql ${s} in the same context. \n \n ${new Error("Stack").stack}`)}else this.#_.set(s,1)})().catch(e=>loggers_1.loggers.runtime.error(e))}logSqlSummary(){if("verbose"!==loggers_1.loggers.performance.logLevel&&"debug"!==loggers_1.loggers.performance.logLevel)return;let e=0;if([...this.#_.keys()].forEach(t=>{const s=this.#_.get(t);if(e+=s,s>1)loggers_1.loggers.performance.verbose(()=>`${t} executed ${s} times`)}),Context.overallSqlExecutionCount+=e,e>0)loggers_1.loggers.performance.verbose(()=>`Total of sql executions: ${e} in this context, ${Context.overallSqlExecutionCount} overall`)}logIgnoredDuplicateMessages(){Object.entries(this._duplicatedLoggedMessages).forEach(([e,t])=>{if(t>1)loggers_1.loggers.runtime.info(`The following message was ignored ${t} times: ${e}`)})}#y;async withReadFunnel(e,t){let s=this.#y.get(e);if(!s)s=(0,xtrem_async_helper_1.funnel)(1),this.#y.set(e,s);const i=await s(t);return this.#y.delete(e),i}executeSql(e,t,s){if(!s?.allowUnsafe)Context.preventSqlInjections(e);return this.logSql(e,t),this.transaction.executeSql(e,t,s)}createSqlReader(e,t,s){if(!s?.allowUnsafe)Context.preventSqlInjections(e);return this.logSql(e,t),this.transaction.createSqlReader(e,t,s)}async getSqlTimestamp(){if(this.managedExternal)throw new Error("SQL timestamp is not supported by externally managed applications");const e=await this.executeSql("SELECT CURRENT_TIMESTAMP::TIMESTAMPTZ(3);",[]);if(1!==e.length)throw new Error("Expected one row");return xtrem_date_time_1.Datetime.fromJsDate(e[0].current_timestamp)}get mayCommit(){return!this.options.noCommit}flushDeferredActions(){return this.transaction.flushDeferredActions()}async createChildContext(e){const t=await Context.create(this.application,{...this.options,...e,parent:this},this.tenantId);if(t.isolatedTransaction=new transaction_1.Transaction(t,e),!e.isDetachedContext)this.children.push(t);return t}async withChildContext(e,t){const randomInt=(e,t)=>Math.floor(Math.random()*(t-e+1)+e),handleError=async(e,t)=>{const s=(0,xtrem_shared_1.unwrapError)(e),i=60;if(!(s instanceof xtrem_postgres_1.DatabaseError))throw e;const r=s;if(t&&"40001"===r.code){const s=t*i/2,r=i*2**t+randomInt(-s,s);this.logger.warn(`transaction retry #${t} in ${r} ms for HTTP request ${(0,request_2.getRequestId)(this.request)}: ${e.innerError?.stack}`),await new Promise(e=>{setTimeout(e,r)})}else if(r.code?.startsWith("23")){if(r.detail)this.logger.error(r.detail);throw this.logger.error(r.message),this.integrityConstraintError(r)}else throw e};if(this.isolatedTransaction){if(!this.mayCommit)try{const t=await e(this);return await this.flushDeferredActions(),t}catch(e){await handleError(e,0)}if(!t.isDetachedContext)throw new xtrem_shared_1.LogicError("cannot have more than one isolated transaction per context")}const s=xtrem_config_1.ConfigManager.current.storage?.sql?.maxRetriesOnTransactionConflicts||10;for(let i=1;i<=s;i+=1){const s=await this.createChildContext(t),{isolatedTransaction:r}=s;if(!r)throw new xtrem_shared_1.LogicError("Isolated transaction must have been set by the child context");try{return await(0,xtrem_log_1.withClsContext)(()=>r.withCommit(()=>e(s)),{context:s})}catch(e){await handleError(e,i)}finally{if(this.diagnoses.push(...s.diagnoses),t.isDetachedContext)await s.close()}}throw new xtrem_shared_1.SystemError(`transaction failed: too many conflict retries: ${s}`)}get isNested(){return!!this.options.parent}runInIsolatedContext(e,t){if(this.checkNotAborted("cannot create a new isolated context"),!this.mayCommit)return(0,concurrency_utils_1.runResolver)(this,()=>e(this));if(this.isIsolated)throw new xtrem_shared_1.LogicError("Cannot create an isolated context, from an existing isolated context.");const s={contextValues:this._contextValues,isolationLevel:t?.isolationLevel||this.isolationLevel||"low",isDetachedContext:true,isIsolated:true,isReadonly:t?.isReadonly||false,source:this.source};if(void 0!==t?.disableTenantCrudNotifications)s.disableTenantCrudNotifications=true;return this.application.requestFunnel(()=>this.withChildContext(t=>(0,concurrency_utils_1.runResolver)(t,()=>e(t)),s))}runInWritableContext(e,t){if(this.checkNotAborted("cannot create a new writable context"),!this.mayCommit)return(0,concurrency_utils_1.runResolver)(this,()=>e(this));if(this.isWritable)throw new xtrem_shared_1.LogicError("Cannot create a writable context, from an existing writable context.");if(!["listener","routing","customMutation","web-socket"].includes(this.source))throw new xtrem_shared_1.LogicError(`Cannot create a writable context outside of a listener, custom mutation or web-socket. Got ${this.source}`);const s={contextValues:this._contextValues,isolationLevel:t?.isolationLevel||this.isolationLevel||"low",noCommit:!!t?.noCommit,isDetachedContext:true,source:t?.source};return this.application.requestFunnel(()=>this.withChildContext(async t=>await(0,concurrency_utils_1.runResolver)(t,()=>e(t)),s))}get isolationLevel(){return this.options.isolationLevel}get timeLimitAsTimestamp(){return this.options.timeLimitAsTimestamp||Number.MAX_SAFE_INTEGER}async withDiagnoses(e,t){if(0===this.diagnosesPrefixes.length)this._diagnoses=[],this._severity=xtrem_shared_1.ValidationSeverity.test;this.diagnosesPrefixes.push(t);try{return await e()}finally{this.diagnosesPrefixes.pop()}}addDiagnoseAtPath(e,t,s){let i;if(this.diagnosesPrefixes.length>1){const t=[this.diagnosesPrefixes.slice(1),s].join(": ");i=new ts_api_1.Diagnose(e,[],t)}else i=new ts_api_1.Diagnose(e,t,s);if(this._severity<e)this._severity=e;if(!this._diagnoses.some(e=>ts_api_1.Diagnose.areEqual(e,i)))this._diagnoses.push(i)}resetDiagnoses(){this._diagnoses=[]}get diagnoses(){return this._diagnoses}get severity(){return this._severity}hasErrors(){return this._severity>=xtrem_shared_1.ValidationSeverity.error}debugString(){return`*** readonly nodes *** ${Object.keys(this.transaction.readonlyNodeStates).map(e=>this.transaction.readonlyNodeStates[e].node.toString()).join("\n")} *** writable nodes *** ${Object.keys(this.transaction.writableNodeStates).map(e=>this.transaction.writableNodeStates[e].node.toString()).join("\n")}`}get introspection(){return new introspection_1.Introspection(this)}get configuration(){return new configuration_service_1.ConfigurationService(this._config)}async create(e,t,s){const i=this.application.getFactoryByConstructor(e);return(await node_state_1.NodeState.newFromContextCreate(this,i,[],t,s)).node}static isKeyMatchingIndices(e,t){if("string"==typeof t||"number"==typeof t)return true;const s=Object.keys(t);if(s.includes("_id"))return true;return!!e.find(e=>true===e.isUnique&&_.intersection(Object.keys(e.orderBy),s).length===s.length)}readNodeState(e,t,s){const i=this.application.getFactoryByConstructor(e),r=i.getAllIndexes();if(r&&!Context.isKeyMatchingIndices(r,t))throw new Error(`Keys don't match any unique index : ${Object.keys(t)}`);return node_state_1.NodeState.newFromRead(this,i,t,s)}async tryRead(e,t,s){if(!await this.application.getFactoryByConstructor(e).isEnabledByServiceOptions(this))return null;const i=await this.readNodeState(e,t,{...s,dontThrow:true});return i?i.node:null}async read(e,t,s){if(!await this.application.getFactoryByConstructor(e).isEnabledByServiceOptions(this))throw new Error(`Node ${this.application.getFactoryByConstructor(e).name} is restricted for reading.`);return(await this.readNodeState(e,t,{...s,dontThrow:false})).node}async deleteMany(e,t,s){const i=this.application.getFactoryByConstructor(e);i.checkCanDeleteMany(this);const r=await i.deleteMany(this,t,{skipControls:false,...s});if(r>0)await i.cache.invalidate(this);return r}delete(e,t){return this.application.getFactoryByConstructor(e).delete(this,t)}async executeGraphql(e){const t=await(0,graphql_1.graphql)({schema:await this.application.getGraphQLSchema(this),source:e,contextValue:this});if(t.errors)t.errors.forEach(e=>loggers_1.loggers.runtime.error(`executeGraphql: ${e.message}`));return t.data}async executeGraphqlStream(e){const t=await(0,graphql_1.graphql)({schema:await this.application.getGraphQLSchema(this),source:e,contextValue:this});if(t.errors)t.errors.forEach(e=>loggers_1.loggers.runtime.error(`executeGraphql: ${e.message}`));return t}query(e,t){return new xtrem_async_helper_1.AsyncArray(async()=>{if(!await this.application.getFactoryByConstructor(e).isEnabledByServiceOptions(this))return[];const s=await(await this.application.getFactoryByConstructor(e).query(this,t)).readAll();if(s.length>=xtrem_config_1.ConfigManager.getSetting("sage/xtrem-core/queryWarnThreshold",1e3))loggers_1.loggers.sql.warn(`${e.name}: 'context.query' returns ${s.length} nodes. Use 'context.queryWithReader' instead. Options=${JSON.stringify(t)}`);return s})}select(e,t,s){const i=this.application.getFactoryByConstructor(e);return sql_select_1.SqlSelect.select(this,i,t,s)}getSelectReader(e,t,s){const i=this.application.getFactoryByConstructor(e);return sql_select_1.SqlSelect.getSelectReader(this,i,t,s)}bulkUpdate(e,t){return sql_1.SqlBulk.update(e,this,t)}bulkDeleteSql(e,t){return sql_1.SqlBulk.delete(e,this,t)}async queryWithReader(e,t,s){if(this.isWritable)loggers_1.loggers.runtime.error("cannot use queryWithReader with writable context",{ignoreCallback:e=>this.shouldIgnoreDuplicateLogs(e)});const i=await this.application.getFactoryByConstructor(e).isEnabledByServiceOptions(this)?await this.application.getFactoryByConstructor(e).query(this,{...t,doNotCache:true}):new xtrem_async_helper_1.AsyncArrayReader(()=>[]);try{return await s(i)}finally{await i.stop()}}queryCount(e,t={}){return this.application.getFactoryByConstructor(e).queryCount(this,t)}walkGroup(e,t){if(null==e||"object"!=typeof e)throw new Error("invalid group: "+(null===e?"null":typeof e));Object.keys(e).forEach(s=>{if("_by"===s)t.groupedBy=e[s];else t.path.push(s),this.walkGroup(e[s],t)})}parseAggregateGroups(e){return Object.keys(e).map(t=>{const s={path:[t]};return this.walkGroup(e[t],s),s})}walkValue(e,t){if(null==e||"object"!=typeof e)throw new Error("invalid value: "+(null===e?"null":typeof e));Object.keys(e).forEach(s=>{const i=e[s];if(true===i)t.operator=s;else t.path.push(s),this.walkValue(i,t)})}parseAggregateValues(e){return Object.keys(e).map(t=>{const s={path:[t]};return this.walkValue(e[t],s),s})}queryAggregate(e,t){return this.query(e,{...t,aggregate:{groups:this.parseAggregateGroups(t.group),values:this.parseAggregateValues(t.values)}})}async readAggregate(e,t){const s=await this.query(e,{...t,aggregate:{groups:[],values:this.parseAggregateValues(t.values)}}).toArray();if(1!==s.length)throw new Error(`readAggregate returns ${s.length} results`);if(!s[0].values)throw new Error("invalid readAggregate result: no values");return s[0].values}async exists(e,t){return!!await this.tryRead(e,t)}static referenceData(e,t){return t}get cache(){return this.#d}getCachedValue(e){return this.application.globalCache.getValue(this,e)}getNodeCacheCategory(e){const t=this.application.getFactoryByConstructor(e);if(!t.isCached)throw t.logicError("cannot get cache category: isCached attribute is not set");return t.cache.cacheCategory}#x;async notifyModifiedCachedCategories(){this.checkNotAborted("cannot notify modified cached categories"),await(0,xtrem_async_helper_1.asyncArray)(this.#x).forEach(e=>this.notifyInvalidateCategory(e.category))}async commitModifiedCachedCategories(){await(0,xtrem_async_helper_1.asyncArray)(this.#x).forEach(e=>this.application.globalCache.invalidateCategory(this,e.category,{skipNotify:true})),this.#x.length=0}rollbackModifiedCachedCategories(){this.#d=new index_1.MemoryCache(this.tenantId||"*","context"),this.#x.length=0}async invalidateCachedCategory(e,t={}){if(this.cache.invalidateCategory(this,e),await this.application.globalCache.invalidateCategory(this,e,{skipNotify:t.skipNotify}),!this.#x.some(t=>t.category===e))this.#x.push({category:e})}async runAsExclusive(e,t){const s=loggers_1.loggers.runtime.verbose(()=>`Exclusive task on key ${e}`);await this.application.globalLock.acquire(this,e);try{const e=await t();return s.success(),e}catch(e){throw s.fail(e.toString()),e}}async buildFilter(e,t,s){switch(typeof e){case"object":{if(null==e)return null;if(Array.isArray(e))return(0,xtrem_async_helper_1.asyncArray)(e).map(e=>this.buildFilter(e,t,s)).toArray();const i={};return await(0,xtrem_async_helper_1.asyncArray)(Object.keys(e)).forEach(async r=>{i[r]=await this.buildFilter(e[r],t,s)}),i}case"function":try{const s=e;return await s.call(t)}catch(t){if(s?.ignoreErrors)return loggers_1.loggers.runtime.error(`cannot build filter ${e} ${t.stack}`),this.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.warn,[],t.message),{};throw t}default:return e}}async checkControlFilter(e,t,s){let i=s.filters?.control;const r=s.getTargetIsActivePropertyName(),a=s.ignoreIsActive;if(!("function"==typeof a?await e.$.state.context.withReadonlyScope(()=>a.call(e)):!!a)&&r)if(e.$.state.status===node_state_1.StateStatus.created||e.$.state.status===node_state_1.StateStatus.modified&&e.$.state.values[s.name]!==(await e.$.old).$.state.values[s.name]){if(!i)i={};i={...i,[r]:true}}if(!i)return true;const n=await this.buildFilter(i,e);return(0,array_utils_1.matchesFilter)(n,t,this.locales)}lookupQuery(e,t={}){return new xtrem_async_helper_1.AsyncArray(async()=>{const s=await this.makeLookupQueryFilters(e,t,{control:true,lookup:true});return this.query(s.referencedNode,{...t,filter:s.filters}).toArray()})}async lookupQueryCount(e,t={}){const s=await this.makeLookupQueryFilters(e,t,{control:true,lookup:true});return this.queryCount(s.referencedNode,{...t,filter:s.filters})}lookup(e,t={}){return new xtrem_async_helper_1.AsyncArray(()=>this.withTransientScope(()=>this.lookupQuery(e,t).toArray()))}lookupCount(e,t,s,i={}){return this.withTransientScope(async()=>{const r=await this.makeLookupQueryParameters(e,t,s);return this.lookupQueryCount(r,i)})}async makeLookupQueryFilters(e,t={},s={control:true,lookup:true}){const i=e.property,r=i.node;let a=i.filters;const n=e.node,o=i.getTargetIsActivePropertyName();if(!i.ignoreIsActive&&o){if(!a)a={};a.lookup={...a.lookup,[o]:true}}const l=s?.lookup?await this.buildFilter(a?.lookup||{},n,{ignoreErrors:true}):{},c=s?.control?await this.buildFilter(a?.control||{},n,{ignoreErrors:true}):{},h=[];if(Object.keys(l).length)h.push(l);if(Object.keys(c).length)h.push(c);if(t?.filter&&Object.keys(t.filter).length)h.push(t.filter);return{lookup:l,control:c,filters:h.length?{_and:h}:{},referencedNode:r}}async makeLookupQueryParametersWithTransientScope(e,t,s){const i=this.application.getFactoryByConstructor(e);let r;const a=s._id||s.data?._id;if(!a||Number(a)<0)r=await this.create(e,s.data||{},{isOnlyForLookup:true,isTransient:true});else{if(!this.managedExternal&&Number.isNaN(Number(a)))throw new Error(`${i.name}.${t}: _id passed to lookup is not a number.`);if(r=await this.read(e,{_id:a},{isOnlyForLookup:true}),s.data)await r.$.state.set({...s.data,_id:a})}const n=i.findProperty(t);if(!n.isReferenceProperty()&&!n.isReferenceArrayProperty())throw new Error(`${i.name}.${t}: invalid property type: ${n.type}`);return{node:r,property:n}}makeLookupQueryParameters(e,t,s){return this.withTransientScope(()=>this.makeLookupQueryParametersWithTransientScope(e,t,s))}async withLocalizedTextAsJson(e){const t=this.processLocalizedTextAsJson;this.processLocalizedTextAsJson=true;try{return await e()}finally{this.processLocalizedTextAsJson=t}}async withoutLocalizedTextAsJson(e){const t=this.processLocalizedTextAsJson;this.processLocalizedTextAsJson=false;try{return await e()}finally{this.processLocalizedTextAsJson=t}}withCsvLoading(e){this._inCsvLoading=true;try{return e()}finally{this._inCsvLoading=false}}get inCsvLoading(){return this._inCsvLoading}async withReferenceAsNaturalKey(e){if(this.isWritable)throw new xtrem_shared_1.LogicError("conversion of reference to natural key is not allowed in a writable context");const t=this.#f;if(!t)this.#f=new context_natural_key_converter_1.ContextNaturalKeyConverter(this);try{return await e()}finally{this.#f=t}}convertReference(e,t){return this.#f?this.#f.convertReference(e,t):Promise.resolve(t)}activateTestServiceOptions(e){Object.values(this.application.serviceOptionsByName).forEach(t=>{if(e.includes(t)&&service_option_manager_1.ServiceOptionManager.isServiceOptionStatusEnabled(t.status)){const enableServiceOption=e=>{if(this.#p[e.name]=true,e.activates)e.activates().forEach(enableServiceOption)};enableServiceOption(t)}else this.#p[t.name]=false})}async isServiceOptionEnabled(e,t){let s=this.#p[e.name];if(void 0===s||t?.noCache)s=await this.application.serviceOptionManager.isServiceOptionEnabled(this,e),this.#p[e.name]=s;return s}setServiceOptionsEnabledFlag(e,t){this.#p[e.name]=t}clearServiceOptionEnabledFlags(){this.#p={}}async initializeFactory(e){if(e)await this.application.getFactoryByConstructor(e).ensureTableExists(this,{skipDrop:true})}hasReadonlyScopes(){return this.nestedReadonlyScopes>0}async withReadonlyScope(e){this.nestedReadonlyScopes+=1;try{return await e()}finally{this.nestedReadonlyScopes-=1}}async withoutReadonlyScopes(e){const t=this.nestedReadonlyScopes;this.nestedReadonlyScopes=0;try{return await e()}finally{this.nestedReadonlyScopes=t}}async withTransientScope(e){this.nestedTransientScopes+=1;try{return await e()}finally{this.nestedTransientScopes-=1}}get isTransient(){return this.nestedTransientScopes>0}static getConfigurationValue(e){if("serviceOptionsLevel"===e)return xtrem_config_1.ConfigManager.current.serviceOptions.level;else return""}async withExternalIds(e){this._allocateExternalIds=true;try{return await e()}finally{this._allocateExternalIds=false}}async withoutGetPropertyValueErrorLogger(e){this.disableGetPropertyValueErrorLogger=true;try{return await e()}finally{this.disableGetPropertyValueErrorLogger=false}}getSqlCacheKey(){return{isolationLevel:this.isolationLevel,locales:this.locales,collation:this.collation,noLazyLoading:this.noLazyLoading,processLocalizedTextAsJson:this.processLocalizedTextAsJson,unsafeApplyToAllTenants:this.unsafeApplyToAllTenants,inCsvLoading:this.inCsvLoading}}async notifyUser(e){await this.application.withCommittedContext(this.tenantId,t=>this.application.notificationManager.dispatchUserNotification(t,e),{userEmail:this.#i,auth:this.#e,locale:this.currentLocale,description:()=>"Send user notification"})}}exports.Context=Context;
//# sourceMappingURL=context.js.map