import { AnyValue } from '@sage/xtrem-async-helper';
import { Package } from '../application';
import { StringArrayPropertyDecorator, StringPropertyDecorator } from '../decorators';
import { NodeFactory } from '../runtime';
import { Property } from './property';
export declare class StringProperty extends Property {
    protected _decorator: StringPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: StringPropertyDecorator, definingPackage: Package);
    get isNotEmpty(): boolean;
    get isLocalized(): boolean;
    get isStoredEncrypted(): boolean;
    /**
     * Overrides Property.maxLength
     */
    get maxLength(): number;
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
    verify(): void;
}
export declare class StringArrayProperty extends Property {
    protected _decorator: StringArrayPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: StringArrayPropertyDecorator, definingPackage: Package);
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
    verify(): void;
}
//# sourceMappingURL=string-property.d.ts.map