import { AnyRecord, AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
import { ColumnTypeName } from '@sage/xtrem-shared';
import { Package } from '../application';
import { CollectionPropertyDecorator, CollectionPropertyOverrideDecorator, ReferenceArrayPropertyDecorator, ReferencePropertyDecorator, ReferencePropertyOverrideDecorator, TypeName } from '../decorators';
import { NodeFactory } from '../runtime/node-factory';
import { Node, NodeQueryFilter, ValidationContext } from '../ts-api';
import { InternalPropertyJoin } from '../types';
import { Property } from './property';
export declare abstract class ForeignNodeProperty extends Property {
    #private;
    protected _decorator: ReferencePropertyDecorator | CollectionPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: ReferencePropertyDecorator | CollectionPropertyDecorator, definingPackage: Package);
    abstract get join(): InternalPropertyJoin<Node> | undefined;
    get decorator(): ReferencePropertyDecorator | CollectionPropertyDecorator;
    verify(): void;
    needsJoin(): boolean;
    verifyJoin(): void;
    get reverseReference(): string | undefined;
    get isVital(): boolean;
    get isAssociation(): boolean;
    get isMutable(): boolean;
    get targetFactory(): NodeFactory;
    get node(): any;
    overrideAttributes(extension: ReferencePropertyOverrideDecorator | CollectionPropertyOverrideDecorator): void;
    /**
     * Creates a filter for the reverse reference and adds the constructor condition if needed.
     * @returns
     */
    protected getReverseReferenceFilter(): InternalPropertyJoin<Node>;
}
export declare class ReferenceProperty extends ForeignNodeProperty {
    #private;
    protected _decorator: ReferencePropertyDecorator;
    private _isSelfReference;
    constructor(factory: NodeFactory, _decorator: ReferencePropertyDecorator, definingPackage: Package);
    get isVitalParent(): boolean;
    get isVitalParentInput(): boolean;
    get canLookup(): boolean;
    get isAssociationParent(): boolean;
    get isSelfReference(): boolean;
    get isRequired(): boolean;
    private verifyExternalStorage;
    /**
     * @returns `true` if this property is a reference that is not nullable or explicitly allowed in indexes
     * by the `allowedInUniqueIndex` attribute and that is not a self reference
     */
    get isHardDependency(): boolean;
    get isToposortDependency(): boolean;
    get ignoreIsActive(): boolean | ((this: Node) => AsyncResponse<boolean>) | undefined;
    verifyDelegatedToProperty(toProperty: Property): void;
    verify(): void;
    get join(): InternalPropertyJoin<Node> | undefined;
    get canTranslateToSql(): boolean;
    get columnType(): ColumnTypeName | undefined;
    get filters(): any;
    isValueTypeValid(value: AnyValue): boolean;
    getTargetIsActivePropertyName(): string | undefined;
    addExtension(extension: ReferencePropertyOverrideDecorator): void;
    overrideAttributes(extension: ReferencePropertyOverrideDecorator): void;
}
export declare class JsonReferenceProperty extends ReferenceProperty {
    protected _decorator: ReferencePropertyDecorator;
    constructor(factory: NodeFactory, _decorator: ReferencePropertyDecorator, definingPackage: Package);
    get type(): TypeName;
    get columnType(): ColumnTypeName | undefined;
}
export declare class ReferenceArrayProperty extends ReferenceProperty {
    protected _decorator: ReferenceArrayPropertyDecorator;
    constructor(factory: NodeFactory, _decorator: ReferenceArrayPropertyDecorator, definingPackage: Package);
    get type(): TypeName;
    get columnType(): ColumnTypeName | undefined;
    isValueTypeValid(value: AnyValue): boolean;
    needsTypeConversion(value: AnyValue): boolean;
    mapInputValue(value: AnyValue): AnyValue;
}
export declare class CollectionProperty extends ForeignNodeProperty {
    protected _decorator: CollectionPropertyDecorator;
    private _prepareBegin?;
    private _prepareEnd?;
    private _controlBegin?;
    private _controlEnd?;
    private _saveBegin?;
    private _saveEnd?;
    constructor(factory: NodeFactory, _decorator: CollectionPropertyDecorator, definingPackage: Package);
    get decorator(): CollectionPropertyDecorator;
    verify(): void;
    addExtension(extension: CollectionPropertyOverrideDecorator): void;
    overrideAttributes(extension: CollectionPropertyOverrideDecorator): void;
    private verifyExternalStorage;
    get join(): InternalPropertyJoin<Node> | undefined;
    get orderBy(): AnyRecord | undefined;
    get prepareBegin(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
    set prepareBegin(prepareBegin: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
    get prepareEnd(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
    set prepareEnd(prepareEnd: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
    get controlBegin(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
    set controlBegin(controlBegin: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
    get controlEnd(): ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined;
    set controlEnd(controlEnd: ((this: Node, cx: ValidationContext) => AsyncResponse<void>) | undefined);
    get saveBegin(): ((this: Node) => void) | undefined;
    set saveBegin(saveBegin: ((this: Node) => void) | undefined);
    get saveEnd(): ((this: Node) => void) | undefined;
    set saveEnd(saveEnd: ((this: Node) => void) | undefined);
    get getFilter(): ((this: Node) => AsyncResponse<NodeQueryFilter<Node>>) | undefined;
    needsJoin(): boolean;
    get forceFullSave(): boolean;
    isValueTypeValid(value: AnyValue): boolean;
}
//# sourceMappingURL=foreign-node-property.d.ts.map