/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateUtils=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),loggers_1=require("../runtime/loggers"),ts_api_1=require("../ts-api"),node_state_1=require("./node-state");class StateUtils{static checkNotStale(e){if(e.status===node_state_1.StateStatus.stale)throw new Error(`${e.interningKeyValues[0]}: invalid operation on stale node`)}static requiredPropertyError(e,t){return e.propertyDataInputError(t,{message:"property is required",key:"@sage/xtrem-core/property-is-required"})}static isEnabledByServiceOptions(e,t){return e.context.isEnabledByServiceOptions(t)}static isPropertyGetterOnly(e){if(e.isCollectionProperty()){if(!(e.isTransientInput||e.isMutable))return true;if(e.getFilter)return true}if(e.isReferenceProperty()&&e.decorator.join&&!e.isMutable)return true;return!(!e.getValue&&!e.computeValue||e.setValue)}static formatStateValues(e){const t=Object.entries(e);return(t.length>1?t.filter(([e])=>"_id"!==e):t).map(([e,t])=>`${e}: ${t}`).join(", ")}static async withValidationErrorRethrow(e,t,r,i){try{await i()}catch(t){if(e.isOnlyForLookup||e.isOnlyForDuplicate)return void loggers_1.loggers.runtime.warn(t.message);if(e.isOnlyForDefaultValues){if(e.context.severity<xtrem_shared_1.ValidationSeverity.exception)e.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.exception,r,t.message);return}if(t instanceof ts_api_1.ValidationError)throw t;throw loggers_1.loggers.runtime.error(t.stack),e.context.addDiagnoseAtPath(xtrem_shared_1.ValidationSeverity.exception,r,t.message),new ts_api_1.ValidationError(e.node,t.message,t)}}static restructureDelegatedInputValues(e,t){const r=e.delegatedProperties;if(0===r.length)return t;const i={...t};return r.forEach(e=>{const t=i[e.name];delete i[e.name];const{reference:r,childProperty:a}=e.getDelegatingInfo();if(void 0===t&&r.isNullable)return;let s=i[r.name];if(!s)s={},i[r.name]=s;if(void 0!==t)s[a.name]=t}),i}}exports.StateUtils=StateUtils;
//# sourceMappingURL=state-utils.js.map