/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateSave=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_shared_1=require("@sage/xtrem-shared"),_=require("lodash"),loggers_1=require("../runtime/loggers"),system_properties_1=require("../runtime/system-properties"),sql_value_converter_1=require("../sql/mapper/sql-value-converter"),ts_api_1=require("../ts-api"),node_state_1=require("./node-state"),state_control_1=require("./state-control"),state_intern_1=require("./state-intern"),state_invalidate_1=require("./state-invalidate"),state_old_1=require("./state-old");class StateSave{static async saveCollectionProperty(e,t,a){const r=await e.getPropertyValue(t);if(t.getValue&&"json"===t.targetFactory.storage)return;if(!t.isMutable)return;if(t.isTransientInput)return;if(t.saveBegin)await t.executeRule(e,"saveBegin");if(await(0,xtrem_async_helper_1.asyncArray)(await r.nodes).forEach(r=>StateSave.saveState(r.$.state,a.concat(t.name,String(r._id)),e)),t.saveEnd)await t.executeRule(e,"saveEnd")}static async saveReferenceProperty(e,t,a){if(t.isTransientInput)return;if(t.getValue&&"json"===t.targetFactory.storage)return;if(!t.isMutable)return;const r=await e.getPropertyValue(t);if(r)await StateSave.saveState(r.$.state,a.concat(t.name),e);if(t.targetFactory.isContentAddressable){if(r&&r._id<0)throw t.logicError(`negative _id after save: ${r._id}`);e.values[t.name]=r?r._id:null,e.references.delete(t.name)}}static async saveProperty(e,t,a){if(t.isCollectionProperty())await StateSave.saveCollectionProperty(e,t,a);else if(t.isReferenceProperty())await StateSave.saveReferenceProperty(e,t,a)}static propagateKeyChangeToTransaction(e,t){e.values._id=t,state_intern_1.StateIntern.updateInternCache(e)}static getMappedIdsKey(e,t){return`${e.rootFactory.name}:${t}`}static updatePropertyValue(e,t,a){const r=system_properties_1.SystemProperties.idProperty(t.factory)===t;if(r){const r=this.getMappedIdsKey(e.factory,e.values[t.name]);e.context.mappedIds[r]=a}if(t.isReferenceProperty()&&e.values[t.name]!==a)e.references.delete(t.name);if(t.isReferenceArrayProperty()&&e.values[t.name]!==a)e.referenceArrays.delete(t.name);if(r)StateSave.propagateKeyChangeToTransaction(e,a);e.values[t.name]=a}static async saveContentAddressableNodeToSqlStorage(e){const t=e.factory.getValuesHash(e.values);if(t!==e.values._valuesHash||Number(e.values._id)<0){await state_old_1.StateOld.keepOldState(e),e.values._valuesHash=t;let a=await e.context.select(e.factory.nodeConstructor,{_id:true},{filter:{_valuesHash:t}});if(1===a.length)e.values._id=a[0]._id;else{const r=await e.context.runInIsolatedContext(t=>e.factory.table.insert(t,_.omit(e.values,"_id"),{onConflictDoNothing:true}));if(await e.factory.invalidateCache(e.context),r._id&&r._id>0)await StateSave.updateReturingValues(e,r);else{if(a=await e.context.select(e.factory.nodeConstructor,{_id:true},{filter:{_valuesHash:t}}),1!==a.length)throw new Error(`Select content addressable node should should return one record, got ${a.length} returned`);e.values._id=a[0]._id}}}e.status=e.status===node_state_1.StateStatus.created?node_state_1.StateStatus.inserted:node_state_1.StateStatus.modified}static getColumnsToUpdate(e){const t=e.factory.table.columnsByColumnName._update_stamp,a=e.dirtyColumnNames;if(t&&0===Object.keys(a).length)a._update_stamp=true;return a}static async saveToSqlStorage(e,t){switch(e.status){case node_state_1.StateStatus.created:{const a=await e.factory.table.insert(e.context,e.values,t);e.status=node_state_1.StateStatus.inserted,await StateSave.updateReturingValues(e,a),await e.factory.cache.invalidate(e.context);break}case node_state_1.StateStatus.modified:{const t=await e.factory.table.update(e.context,e.values,{onlyColumns:this.getColumnsToUpdate(e)});if(t.length>1)throw new Error(`update should have modified at most one record, got ${t.length} modified`);if(t.length)await StateSave.updateReturingValues(e,t[0]);e.dirtyColumnNames={},await e.factory.cache.invalidate(e.context);break}case node_state_1.StateStatus.updatable:break;default:throw new xtrem_shared_1.LogicError(`cannot save ${e.factory.name}:${e.node}: bad status: ${e.status}`)}}static async updateReturingValues(e,t){const a=e.factory,r=[...a.properties,...system_properties_1.SystemProperties.getSystemProperties(a)];await(0,xtrem_async_helper_1.asyncArray)(Object.keys(t)).forEach(async a=>{const s=r.find(e=>e.columnName===a);if(!s)throw new Error(`cannot set returning value of ${a}: no property found`);const o={sql:"",property:s,type:s.type},n=await sql_value_converter_1.SqlValueConverter.fromSql(e.context,o,t[a]);StateSave.updatePropertyValue(e,s,n)})}static updateExternalReturningValues(e,t){const a=e.factory;Object.keys(t).forEach(r=>{const s=a.findProperty(r,{includeSystemProperties:true}),o=t[r];StateSave.updatePropertyValue(e,s,o)})}static async saveToExternalStorage(e,t,a){switch(e.status){case node_state_1.StateStatus.created:{if(!t.insert)throw e.systemError("externalStorageManager.insert decorator missing");const r=await t.insert(e.node,a);e.status=node_state_1.StateStatus.inserted,StateSave.updateExternalReturningValues(e,r);break}case node_state_1.StateStatus.modified:{if(!t.update)throw e.systemError("externalStorageManager.update decorator missing");const r=await t.update(e.node,a);if(r.length>0)StateSave.updateExternalReturningValues(e,r[0]);break}case node_state_1.StateStatus.updatable:case node_state_1.StateStatus.readonly:break;default:throw new xtrem_shared_1.LogicError(`cannot save ${e.node}: bad status: ${e.status}`)}}static async saveToStorage(e,t,a){if(e.context.transaction.incrementFactoryTick(e.factory),"sql"===e.factory.storage)if(e.factory.isContentAddressable)await StateSave.saveContentAddressableNodeToSqlStorage(e);else await StateSave.saveToSqlStorage(e,a);else if("external"===e.factory.storage)await StateSave.saveToExternalStorage(e,e.factory.externalStorageManager,new ts_api_1.ValidationContext(e.node,t));else throw new Error(`cannot save ${e.node}: invalid storage type: ${e.factory.storage}`)}static fixNegativeId(e,t,a=e.values[t.name]){const r=Number(a);if(!Number.isFinite(r)||r>=0)return true;const s=this.getMappedIdsKey(t.targetFactory,r),o=e.context.mappedIds[s];if(o>0)return e.values[t.name]=o,true;return false}static async saveState(e,t,a,r){if("constructed"===e.status)throw e.logicError("Cannot save node which has not been fully constructed");if(e.skipSave)return;if(e.factory.events.saveBegin)await e.factory.executeRule(e,"saveBegin");const s=[],o=[];if(await(0,xtrem_async_helper_1.asyncArray)(e.factory.properties).forEach(async a=>{if(!a.isReferenceProperty())return;if(a.isMutable&&a.targetFactory.isContentAddressable)await StateSave.saveProperty(e,a,t);else if(!this.fixNegativeId(e,a)&&a.isNullable)s.push({property:a,oldValue:e.values[a.name]});else if(a.isSelfReference&&e.values[a.name]===e.values._id&&Number(e.values[a.name])<0)o.push({property:a,oldValue:e.values[a.name]})}),s.forEach(t=>{e.values[t.property.name]=null}),await StateSave.saveToStorage(e,t,r),e.context.intern.flushState(e),await(0,xtrem_async_helper_1.asyncArray)(e.factory.properties.filter(e=>e.isMutable&&!(e.isReferenceProperty()&&e.targetFactory.isContentAddressable))).forEach(a=>StateSave.saveProperty(e,a,t)),e.factory.events.saveEnd)await e.factory.executeRule(e,"saveEnd");if(e.status===node_state_1.StateStatus.modified||e.status===node_state_1.StateStatus.inserted)e.status=node_state_1.StateStatus.updatable;if(a)a.statesToUpdate=[...a.statesToUpdate,...e.statesToUpdate];if(s.length)s.forEach(t=>this.fixNegativeId(e,t.property,t.oldValue)),e.status=node_state_1.StateStatus.modified,e.statesToUpdate.push([e,t]);if(o.length)o.forEach(t=>this.fixNegativeId(e,t.property,t.oldValue));if(void 0===a)await(0,xtrem_async_helper_1.asyncArray)(e.statesToUpdate).forEach(async e=>{await StateSave.saveToStorage(e[0],e[1]),e[0].status=node_state_1.StateStatus.updatable});if(r?.flushDeferredActions)await e.context.flushDeferredActions()}static async clearVitalParentChildren(e){const t=e.factory,a=t.vitalParentProperty,r=t.vitalParentFactory,s=e.values[a.name],o=Object.values(state_intern_1.StateIntern.getInterningKeysFromValues(r,{_id:s}))[0],n=r.properties.filter(e=>e.isForeignNodeProperty()&&e.isVital&&e.targetFactory===t),cleanVitalChildren=async t=>{const a=e.context.intern.getState(o,t);if(a)await(0,xtrem_async_helper_1.asyncArray)(n).forEach(async r=>{if(r.isCollectionProperty()){const s=a.collections.get(r.name);if(s&&s.isLoaded)if(t){if(!await s.find(t=>t._id===e.id))await s.appendNode(e.node);if(!s.hasSortValue)await s.sortBySortValue()}else a.collections.delete(r.name)}else if(r.isReferenceProperty()){const s=a.references.get(r.name);if(!t)if(s&&s._id===e.id)a.references.delete(r.name)}})};await cleanVitalChildren(true),await cleanVitalChildren(false)}static clearMutableChildren(e){e.factory.strictMutableProperties.forEach(t=>{if(t.isCollectionProperty()){const a=e.collections.get(t.name);if(a&&a.isLoaded)e.collections.delete(t.name)}else if(t.isReferenceProperty()){const a=e.references.get(t.name);if(a&&a._id===e.id)e.references.delete(t.name)}})}static async computeSkipSave(e){if("sql"!==e.factory.storage)return;if(e.skipSave="updatable"===e.status&&(e.factory.isVitalCollectionChild||e.factory.isAssociationCollectionChild),await(0,xtrem_async_helper_1.asyncArray)(e.factory.properties).forEach(async t=>{if("readonly"!==e.status)await state_invalidate_1.StateInvalidate.validatePropertyValue(e,t,[t.name]);if(t.isCollectionProperty()&&t.isMutable){if(t.forceFullSave)return void(e.skipSave=false);const a=e.collections.get(t.name);if(!a)return;return void await a.forEach(async t=>{const a=t.$.state;if(!a)return;if(await this.computeSkipSave(a),!a.skipSave)e.skipSave=false})}if(t.isReferenceProperty()&&t.isMutable){const a=e.references.get(t.name);if(!a)return;const r=a.$.state;if(await this.computeSkipSave(r),!r.skipSave)e.skipSave=false}}),e.skipSave)loggers_1.loggers.runtime.verbose(()=>`Skipping save: ${e.factory.name}.${e.keyToken}`)}static async trySave(e,t={}){const a=e.factory;if(a.checkCanUpdate(e.context),await this.computeSkipSave(e),t.deferred)return e.context.queueDeferredSave(e.node),Promise.resolve(true);return e.context.withDiagnoses(async()=>{if(!a.externalStorageManager?.skipValidation&&!await state_control_1.StateControl.control(e))return false;if(!t.controlOnly){if("sql"!==a.storage&&"external"!==a.storage)throw new Error(`Save ${a.name} is a forbidden operation : storage is not sql or external.`);if(await StateSave.saveState(e,[],void 0,t),a.isVitalChild)await this.clearVitalParentChildren(e);this.clearMutableChildren(e)}return true},`While saving ${a.name}(${e.keyToken})`)}}exports.StateSave=StateSave;
//# sourceMappingURL=state-save.js.map