/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateLoad=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),sql_1=require("../sql"),node_state_1=require("./node-state"),state_intern_1=require("./state-intern"),state_utils_1=require("./state-utils"),lodash=require("lodash");class StateLoad{static async readFromDatabase(t,e){return(await t.factory.createNodeQuery(t.context,{filter:e,forUpdate:t.forUpdate,singleResultRequest:true})).getNodeData()}static getKeyFilter(t){if(t.values._id&&Number.isFinite(Number(t.values._id))&&Number(t.values._id)>0||"string"==typeof t.values._id)return"sql"===t.factory.storage?t.factory.parseNodeId(t.values._id):{_id:t.values._id};return Object.keys(t.values).forEach(e=>{if("_constructor"===e)return;const a=t.factory.findProperty(e);if(!(a.isStored||a.getValue))throw new xtrem_shared_1.DataInputError(`${a.fullName}: invalid key property`)}),lodash.omit(t.values,"_id")}static loadFromFunnel(t){if(!t.isThunk)return t.status!==node_state_1.StateStatus.stale;const e=StateLoad.getKeyFilter(t);if(Object.values(e).every(t=>void 0===t))return state_intern_1.StateIntern.removeState(t),t.status=node_state_1.StateStatus.stale,false;const a=t.interningKeyValues[0];return t.context.withReadFunnel(a,async()=>{if(!t.isThunk)return t.status!==node_state_1.StateStatus.stale;const a=await t.factory.getAccessRightsFilter(t.context),r=[e];if(a)r.push(a);let s=await t.factory.cache.fetch(t.context,{getKey:()=>JSON.stringify({filters:r,context:t.context.getSqlCacheKey()}),getValue:async()=>({value:await this.readFromDatabase(t,e),storedEncryptedProperties:t.factory.storedEncryptedProperties}),isolateInContext:t.forUpdate});if(!s&&a){const a=await(await sql_1.SqlQuery.create(t.context,t.factory,{filters:[e],forUpdate:false,singleResultRequest:true})).getNodeData();if(a)return t.factory.naturalKey?.forEach(e=>{if(t.values[e]!==a[e])t.values[e]=a[e]}),state_intern_1.StateIntern.removeState(t),t.status=node_state_1.StateStatus.unauthorized,false}if(s&&t.context.isTransient)s={...s};if(t.isThunk=false,!s)return state_intern_1.StateIntern.removeState(t),t.status=node_state_1.StateStatus.stale,false;if(t.values=s,t.setLazyLoadMarkers(),!t.factory.isAbstract)state_intern_1.StateIntern.updateInternCache(t);return true})}static tryLoad(t){if("sql"!==t.factory.storage&&"external"!==t.factory.storage)throw t.systemError(`cannot load: bad class storage: ${String(t.factory.storage)}`);if(!t.isThunk)return t.status!==node_state_1.StateStatus.stale;return StateLoad.loadFromFunnel(t)}static async load(t){if(!await this.tryLoad(t)){if(t.status===node_state_1.StateStatus.unauthorized)throw t.dataInputError({message:"Unauthorized: {{values}}",key:"@sage/xtrem-core/record-not-found-unauthorized",data:{values:state_utils_1.StateUtils.formatStateValues(t.values)}});throw t.dataInputError({message:"record not found: {{values}}",key:"@sage/xtrem-core/record-not-found",data:{values:JSON.stringify(t.values)}})}}static async resolveLazyLoadedValue(t,e){const a=`${t.interningKeyValues[0]}:${e.name}`,r=await t.context.withReadFunnel(a,()=>StateLoad._resolveLazyLoadedValueFromFunnel(t,e));if(null==r)throw new Error(`Lazy-loading of ${t.factory.name}[${t.id}].${e.name} failed, state=${t.status}`);return t.values[e.name]=r[e.name],r[e.name]}static async _resolveLazyLoadedValueFromFunnel(t,e){return(await t.factory.createLazyLoadedValueQuery(t.context,t.id,[e])).getNodeData()}}exports.StateLoad=StateLoad;
//# sourceMappingURL=state-load.js.map