/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.StateDuplicate=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),_=require("lodash"),decorators_1=require("../decorators"),state_dependency_1=require("./state-dependency"),state_init_1=require("./state-init");class StateDuplicate{static convertVitalData(e,t,a,r=false){if(!t)return;if(e.isContentAddressable&&t._id)delete t._id;if(t._id){const r=-Math.abs(Number(t._id));a.set(`${e.name}~${t._id}`,r),t._id=r}const i=e.properties.filter(e=>e.isForeignNodeProperty()&&!e.isSystemProperty&&Object.keys(t).includes(e.name));if(e.hasVendorProperty&&null!=t._vendor)delete t._vendor;i.forEach(e=>{if(e.isMutable){if(e.isCollectionProperty())t[e.name].forEach(t=>{StateDuplicate.convertVitalData(e.targetFactory,t,a,true)});if(e.isReferenceProperty())StateDuplicate.convertVitalData(e.targetFactory,t[e.name],a,true)}else if(e.isVitalParent&&!e.isAssociationParent)if(!r)delete t._sortValue})}static convertNonVitalReferenceData(e,t,a){if(!t)return;e.properties.filter(e=>e.isForeignNodeProperty()&&Object.keys(t).includes(e.name)).forEach(e=>{if(e.isMutable){if(e.isCollectionProperty())t[e.name].forEach(t=>{StateDuplicate.convertNonVitalReferenceData(e.targetFactory,t,a)});if(e.isReferenceProperty())StateDuplicate.convertNonVitalReferenceData(e.targetFactory,t[e.name],a)}else if(t[e.name]&&e.isReferenceProperty()&&a.has(`${e.targetFactory.name}~${t[e.name]?._id}`))t[e.name]=a.get(`${e.targetFactory.name}~${t[e.name]?._id}`);else if(t[e.name]&&Array.isArray(t[e.name])&&e.isReferenceArrayProperty())t[e.name]=t[e.name].map(t=>{const r=`${e.targetFactory.name}~${t._id}`;if(a.has(r))return a.get(r);return t})})}static async getForeignNodePropertyDuplicatedValue(e,t,a,r){if(t.isCollectionProperty()&&Array.isArray(a)){const i=await e.getPropertyValue(t);return(0,xtrem_async_helper_1.asyncArray)(a).map(async(e,t)=>{const a=await i.at(t);if(!a)throw new Error(`${r.join(".")}: collection value not found at index ${t}`);return this.setDuplicatedValuesInData(a.$.state,e,r)}).toArray()}if(t.isReferenceProperty()){const i=await e.getPropertyValue(t);if(null==i)return;return this.setDuplicatedValuesInData(i.$.state,a,r)}return}static async getPropertyDuplicatedValue(e,t){let a=t.duplicatedValue;if(void 0!==a){if("function"==typeof a)a=await state_dependency_1.StateDependency.withDependenciesRestriction(e,t,()=>e.context.withReadonlyScope(()=>t.executeRule(e,"duplicatedValue")));if(a===decorators_1.useDefaultValue)a=await state_init_1.StateInit.getDefaultValue(e,t);else if(null===a)a=t.getTypeDefaultValue();return await e.setPropertyValue(t,a),a}if(t.isStringProperty()&&t.isStoredEncrypted){const a=state_init_1.StateInit.getDefaultValue(e,t);return await e.setPropertyValue(t,a),a}return}static async setDuplicatedValuesInData(e,t,a){const r={...t};return await(0,xtrem_async_helper_1.asyncArray)(e.factory.properties).forEach(async t=>{const i=r[t.name],n=t.name,o=null==a?[n]:[...a,n];if(t.isForeignNodeProperty()&&t.isMutable&&void 0===t.duplicatedValue){if(null!=i){const a=await this.getForeignNodePropertyDuplicatedValue(e,t,i,o);if(void 0!==a)r[n]=a}}else{const a=await this.getPropertyDuplicatedValue(e,t);if(void 0!==a)r[n]=a}}),r}static async duplicateState(e,t,a){if("external"===e.factory.storage)throw e.logicError("Cannot duplicate a node with external storage");const r=await e.payload(t),i=new Map;StateDuplicate.convertVitalData(e.factory,r,i),StateDuplicate.convertNonVitalReferenceData(e.factory,r,i);const n=await e.context.create(e.factory.nodeConstructor,r,{isOnlyForDuplicate:true,isTransient:true}),o=await this.setDuplicatedValuesInData(n.$.state,r);if(a?.isTransient){if(a.data)await n.$.set(a.data);return n.$.state}const s=a?.data?_.merge(o,a.data):o;return(await e.context.create(e.factory.nodeConstructor,s,{})).$.state}static duplicate(e,t){return this.duplicateState(e,{withIds:true},{data:t})}static getDuplicate(e,t){return this.duplicateState(e,{withIds:true,limitCollections:t?.limitCollections},{isTransient:true})}}exports.StateDuplicate=StateDuplicate;
//# sourceMappingURL=state-duplicate.js.map