/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NodeState=exports.StateStatus=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),ts_api_1=require("../ts-api"),lazy_loaded_marker_1=require("./lazy-loaded-marker"),state_cursor_1=require("./state-cursor"),state_delete_1=require("./state-delete"),state_duplicate_1=require("./state-duplicate"),state_get_value_1=require("./state-get-value"),state_init_1=require("./state-init"),state_intern_1=require("./state-intern"),state_join_1=require("./state-join"),state_new_1=require("./state-new"),state_old_1=require("./state-old"),state_payload_1=require("./state-payload"),state_save_1=require("./state-save"),state_set_value_1=require("./state-set-value");var StateStatus;!function(t){t.readonly="readonly",t.constructed="constructed",t.created="created",t.inserted="inserted",t.deleted="deleted",t.updatable="updatable",t.modified="modified",t.stale="stale",t.unauthorized="unauthorized"}(StateStatus||(exports.StateStatus=StateStatus={}));class NodeState{static{this.nextDebugId=0}#t;constructor(t,e,a,r,s){if(this.factory=e,this.values={},this.statesToUpdate=[],this.references=new Map,this.referenceArrays=new Map,this.collections=new Map,this.invalidProperties=new Set,this.deferredProperties={},this.dirtyColumnNames={},this.dependencyLimit=Number.MAX_SAFE_INTEGER,this.debugId=0,this.skipSave=false,this.debugId+=NodeState.nextDebugId,NodeState.nextDebugId+=1,this.#t=t,this.values=a,"constructed"!==r&&"readonly"!==r&&"updatable"!==r)throw new Error(`invalid state status: ${r}`);this.status=r,this.forUpdate=!!s.forUpdate,this.collection=s.collection,this.isThunk=!!s.isThunk,this.isTransient=!!s.isTransient,this.isOnlyForDefaultValues=!!s.isOnlyForDefaultValues,this.isOnlyForDuplicate=!!s.isOnlyForDuplicate,this.isOnlyForLookup=!!s.isOnlyForLookup,this.isOld=!!s.isOld,this.node=new e.nodeConstructor(this)}get interningKeys(){return state_intern_1.StateIntern.getInterningKeys(this)}get interningKeyValues(){return Object.values(this.interningKeys)}get collection(){return this._collection}set collection(t){this._collection=t}get context(){return this.#t}get nodeStatus(){switch(this.status){case StateStatus.readonly:case StateStatus.updatable:return ts_api_1.NodeStatus.unchanged;case StateStatus.constructed:case StateStatus.created:case StateStatus.inserted:return ts_api_1.NodeStatus.added;case StateStatus.deleted:return ts_api_1.NodeStatus.deleted;case StateStatus.modified:return ts_api_1.NodeStatus.modified;case StateStatus.stale:case StateStatus.unauthorized:return ts_api_1.NodeStatus.invalid;default:throw this.systemError(`invalid status: ${this.status}`)}}get isReadonly(){return this.status===StateStatus.readonly&&!this.isTransient&&!this.context.isTransient}get isWritable(){return!this.isReadonly}get isNew(){return[StateStatus.created,StateStatus.constructed].includes(this.status)}get isEffectivelyReadonly(){return this.isReadonly||this.context.hasReadonlyScopes()}get isStale(){return this.status===StateStatus.stale}getPropertyValue(t){return state_get_value_1.StateGetValue.getPropertyValue(this,t)}getPropertyValueSync(t){return state_get_value_1.StateGetValue.getPropertyValueSync(this,t)}async getValue(t){const e=this.factory.findProperty(t,{includeSystemProperties:true});return await state_get_value_1.StateGetValue.getPropertyValue(this,e)}getValueSync(t){const e=this.factory.findProperty(t,{includeSystemProperties:true});return state_get_value_1.StateGetValue.getPropertyValueSync(this,e)}async setPropertyValue(t,e){await state_set_value_1.StateSetValue.setPropertyValue(this,t,[t.name],e)}setValue(t,e){const a=this.factory.findProperty(t);return state_set_value_1.StateSetValue.setPropertyValue(this,a,[a.name],e)}async set(t,e){await state_set_value_1.StateSetValue.setState(this,t,e)}isPropertyValueDeferred(t){return!!this.deferredProperties[t.name]}get old(){return(async()=>(await state_old_1.StateOld.getOldState(this)).node)()}get id(){return this.values._id}get sortValue(){if(!this.factory.isVitalCollectionChild)throw this.systemError("cannot get _sortValue, node is not a vital collection child");if(this.factory.isAssociationChild)throw this.systemError("cannot get _sortValue, node is an association child");return this.getValue("_sortValue")}get vendor(){if(!this.factory.hasVendorProperty)return Promise.resolve(null);return this.getValue("_vendor")}async setSortValue(t){if(!this.factory.isVitalCollectionChild)throw this.systemError("cannot set _sortValue, node is not a vital collection child");if(this.factory.isAssociationChild)throw this.systemError("cannot set _sortValue, node is an association child");await this.setValue("_sortValue",t)}get createdBy(){return this.getValue("_createUser")}get updatedBy(){return this.getValue("_updateUser")}get createStamp(){return this.getValue("_createStamp")}get updateStamp(){return this.getValue("_updateStamp")}get syncTick(){return this.getValue("_syncTick")}get syncInfo(){return this.getValue("_syncInfo")}get etag(){return this.getValue("_etag")}get customData(){return this.getValue("_customData")}get valuesHash(){if(!this.factory.isContentAddressable)throw this.factory.logicError("factory is not content addressable");return this.getValue("_valuesHash")}get attachments(){return this.getValueSync("_attachments")}addDiagnose(t,e,a){this.context.addDiagnoseAtPath(t,e,a)}control(){return state_save_1.StateSave.trySave(this,{controlOnly:true})}async trySave(t){const e=await state_save_1.StateSave.trySave(this,t);if(e)this.oldState=void 0;return e}async save(t){if(!await this.trySave(t))throw new ts_api_1.ValidationError(this.node)}tryDelete(t){return state_delete_1.StateDelete.tryDelete(this,t)}delete(t){return state_delete_1.StateDelete.delete(this,t)}getKeyValues(){return this.factory.getKeyValues(this.context,this.values)}get keyToken(){return this.factory.getToken(this.values)}getNaturalKeyValue(){return state_get_value_1.StateGetValue.getNaturalKeyValue(this)}getCursorValue(t){return state_cursor_1.StateCursor.getCursorValue(this,t)}getJoinValues(t){return state_join_1.StateJoin.getJoinValues(this,t)}payload(t){return state_payload_1.StatePayload.getPayload(this,t)}duplicate(t){return state_duplicate_1.StateDuplicate.duplicate(this,t)}propertySystemError(t,e){return new xtrem_shared_1.SystemError(`${this.factory.name}.${t.name}: ${e}`)}propertyDataInputError(t,e){const a=this.context.localize(e.key,e.message,e.data||{});return new xtrem_shared_1.DataInputError(`${this.factory.name}.${t.name}: ${a}`,e.innerError)}systemError(t){return new xtrem_shared_1.SystemError(`${this.factory.name}: ${t}`)}logicError(t){return new xtrem_shared_1.LogicError(`${this.factory.name}: ${t}`)}dataInputError(t){const e=this.context.localize(t.key,t.message,t.data||{});return new xtrem_shared_1.DataInputError(`${this.factory.name}: ${e}`,t.innerError)}static newFromContextCreate(t,e,a,r,s){return state_init_1.StateInit.newFromContextCreate(t,e,a,r,s)}static newFromRead(t,e,a,r){return state_new_1.StateNew.newFromRead(t,e,a,r)}static newFromQuery(t,e,a,r){return state_new_1.StateNew.newFromQuery(t,e,a,r)}setLazyLoadMarkers(){if("sql"!==this.factory.storage||this.#t.noLazyLoading)return;this.factory.lazyLoadedProperties.forEach(t=>{this.values[t.name]=lazy_loaded_marker_1.lazyLoadedMarker})}isNodeFrozen(){if(this.context.bypassFrozen)return false;const t=this.factory.nodeDecorator.isFrozen;if("function"!=typeof t)return!!t;return this.context.withReadonlyScope(()=>this.factory.executeRule(this,"isFrozen"))}isPropertyFrozen(t){if(this.context.bypassFrozen)return false;const e=t.isFrozen;if("function"!=typeof e)return!!e;return this.context.withReadonlyScope(()=>t.executeRule(this,"isFrozen"))}}exports.NodeState=NodeState;
//# sourceMappingURL=node-state.js.map