/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.CustomMetrics=exports.CustomCounters=exports.allMetricsEnabled=void 0;const xtrem_log_1=require("@sage/xtrem-log"),xtrem_shared_1=require("@sage/xtrem-shared"),express=require("express"),prom_client_1=require("prom-client"),EventEmitter=require("node:events"),logger=xtrem_log_1.Logger.getLogger(__filename,"metrics");exports.allMetricsEnabled=(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_ALL_METRICS_ENABLED);const nodeJsMetricsEnabled=exports.allMetricsEnabled||(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_NODEJS_METRICS_ENABLED),ruleMetricsEnabled=exports.allMetricsEnabled||(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_RULE_METRICS_ENABLED),graphQlMetricsEnabled=exports.allMetricsEnabled||(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_GRAPHQL_METRICS_ENABLED),sqlMetricsEnabled=exports.allMetricsEnabled||(0,xtrem_shared_1.isEnvVarTrue)(process.env.XTREM_SQL_METRICS_ENABLED);if(nodeJsMetricsEnabled)(0,prom_client_1.collectDefaultMetrics)({register:prom_client_1.register});class CustomCounters{#e;#t;constructor(e){const{labelNames:t,name:r,help:s}=e;this.#e=e.isEnabled,this.#t={calls:new prom_client_1.Counter({name:`xtrem_${r}_calls`,help:`Number of calls of ${s}`,labelNames:t}),errors:new prom_client_1.Counter({name:`xtrem_${r}_errors`,help:`Number of errors of ${s}`,labelNames:t}),totalMillis:new prom_client_1.Counter({name:`xtrem_${r}_total_millis`,help:`Total duration for ${s} (in milliseconds)`,labelNames:t})}}get isEnabled(){return this.#e}increment(e,t,r){if(this.#t.calls.labels(e).inc(1),r)this.#t.errors.labels(e).inc(1);this.#t.totalMillis.labels(e).inc(t)}async withMetrics(e,t){if(!this.#e)return t();const r=Date.now();let s=false;try{return await t()}catch(e){throw s=true,e}finally{this.increment(e,Date.now()-r,s)}}wrapReader(e,t){if(!this.#e)return t;const r=Object.create(t);return r.read=()=>0===t.readCount?this.withMetrics(e,()=>t.read()):t.read(),r}}exports.CustomCounters=CustomCounters;class CustomMetrics{static{this.emitter=new EventEmitter}static{this.rules=new CustomCounters({name:"rules",help:"a business rule",labelNames:["nodeName","propertyName","ruleName"],isEnabled:ruleMetricsEnabled})}static{this.graphql=new CustomCounters({name:"graphql",help:"a graphql operation",labelNames:["nodeName","operationName","operationKind"],isEnabled:graphQlMetricsEnabled})}static{this.metadata=new CustomCounters({name:"metadata",help:"a metadata operation",labelNames:["nodeName","operationName","operationKind"],isEnabled:graphQlMetricsEnabled})}static{this.sql=new CustomCounters({name:"sql",help:"a sql statement",labelNames:["nodeName","statementKind"],isEnabled:sqlMetricsEnabled})}static get expressApp(){const e=express();return e.get("/",async(e,t)=>{logger.verbose(()=>"Received HTTP GET on /metrics endpoint");try{t.set("Content-Type",prom_client_1.register.contentType),t.end(await prom_client_1.register.metrics()),this.emitter.emit("collected")}catch(e){logger.error(e),t.status(500).send()}}),e}}exports.CustomMetrics=CustomMetrics;
//# sourceMappingURL=custom-metrics.js.map