/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.InteropGraphqlClient=exports.logger=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_log_1=require("@sage/xtrem-log"),xtrem_shared_1=require("@sage/xtrem-shared"),axios_1=require("axios"),contentType=require("content-type"),jwt=require("jsonwebtoken"),_=require("lodash"),node_http_1=require("node:http"),core_hooks_1=require("../runtime/core-hooks"),secret_manager_1=require("../runtime/secret-manager"),security_1=require("../security");function isAggregateError(e){return void 0!==e.errors}function isAxiosError(e){return void 0!==e.isAxiosError}function tryParseJson(e){try{return JSON.parse(e)}catch(e){return{}}}function logIncomingMessageData(e){let t="";e.on("data",e=>{t+=e}),e.on("end",()=>{exports.logger.verbose(()=>`graphql stream response ${String(t)}`)})}exports.logger=xtrem_log_1.Logger.getLogger(__filename,"interop");class InteropGraphqlClient{static getSignatureKey(e){const t={xtremEnv:process.env.XTREM_ENV,clusterId:xtrem_config_1.ConfigManager.current?.clusterId};return secret_manager_1.SecretManager.getTenantEncryptionKey(t,e)}static async getBearerToken(e){const{tenantId:t}=e;if(!t)throw new xtrem_shared_1.LogicError("missing tenantId");const r=await this.getSignatureKey(t);return jwt.sign(e,r,{algorithm:"HS256",expiresIn:"2m"})}static async parseBearerToken(e){const{tenantId:t}=jwt.decode(e),r=await this.getSignatureKey(t),s=jwt.verify(e,r);if(!(s.tenantId&&s.appName&&s.scope&&s.sourceUserEmail))throw new Error("invalid bearer token");return s}static getScopeUserEmail(e){return`scope-${e}@localhost.domain`}static getUrl(e,t){const r=xtrem_config_1.ConfigManager.current.apps?.[e]?.[t];if(!r)throw new xtrem_shared_1.LogicError(`${e}: ${t} is not configured`);return r}static getAppUrl(e){return InteropGraphqlClient.getUrl(e,"appUrl")}static getInteropUrl(e){return InteropGraphqlClient.getUrl(e,"interopUrl")}static getRequestConfig(e,t={}){return _.merge({headers:e,validateStatus:e=>401===e||e>=200&&e<300,httpsAgent:(0,security_1.getInteropHttpsAgent)()},t)}static async sendAnyGraphqlRequest(e,{appName:t,scope:r,query:s,variables:n={},config:a={}}){const o=`${this.getInteropUrl(t)}${(await core_hooks_1.CoreHooks.interopManager.getInteropAppInfo(e,t)).isConnector?"/proxy":"/api"}`,{tenantId:i,cloudflareRayID:g,originId:p}=e;if(!i)throw new xtrem_shared_1.LogicError("missing tenantId");const c=await core_hooks_1.CoreHooks.interopManager.getTenantApps(i);if(!c||!c.includes(t))throw new Error(`App ${t} is not provisioned for tenant ${i}`);const u=(await e.user)?.email;if(!u)throw new xtrem_shared_1.LogicError("missing sourceUserEmail");const l=await this.getBearerToken({appName:t,tenantId:i,scope:r,sourceUserEmail:u}),d=InteropGraphqlClient.getRequestConfig({Authorization:`Bearer ${l}`,"accept-language":e.currentLocale,accept:"application/json","cf-ray":g,"x-request-id":p},a);exports.logger.debug(()=>`sending graphql query ${s} with ${JSON.stringify(n)}, axiosConfig=${JSON.stringify(d)}`);try{const e=await axios_1.default.post(o,{query:s,variables:n},d);if(401===e.status)throw exports.logger.error(`Authentication error: ${e.status} ${e.statusText} - ${JSON.stringify(e.data||"no data")}`),new Error(`Request failed with status code ${e.status} ${e.statusText}`);if(exports.logger.isActive("debug"))if(e.data instanceof node_http_1.IncomingMessage)logIncomingMessageData(e.data);else exports.logger.debug(()=>`graphql response [${e.data?JSON.stringify(e.data.constructor.name):JSON.stringify(e.data)}] ${String(JSON.stringify(e.data))}`);return e}catch(e){throw InteropGraphqlClient.interopError(t,e)}}static interopError(e,t){const r=new xtrem_shared_1.InteropError(t.message,t);if(isAxiosError(t)){if(!r.message)r.message=`Request failed with code ${t.code}`;if(t.response){r.extensions.http={status:t.response.status,statusText:t.response.statusText};const e=contentType.parse(t.response.headers?.["content-type"]??""),s=t.response.data;if(r.message=`${t.response.status} ${t.response.statusText}`,"application/json"===e.type){const e=tryParseJson("string"==typeof s&&s||"{}");r.extensions.rawError=e.error||e.message||e.errors||e.diagnoses||e.$diagnoses}else if("text/plain"===e.type&&"string"==typeof s)r.message=s}}if(isAggregateError(t)&&Array.isArray(t.errors)){if(!r.message)r.message=`Request failed with code ${t.errors[0]?.code??"<unknown>"}`;t.errors.forEach(e=>{exports.logger.error(e.toString())})}return r.message=`[${e}] ${r.message}`,r.extensions.diagnoses[0].message=r.message,exports.logger.error(`interop error: ${r.message}, extensions=${JSON.stringify(r.extensions)}`),r}static sendGraphqlRequest(e,t){return this.sendAnyGraphqlRequest(e,t)}static sendStreamGraphqlRequest(e,t){const r=_.merge(t.config,{headers:{"accept-encoding":"identity"}});return this.sendAnyGraphqlRequest(e,{...t,config:r})}static async getAppHealth(e){const t=Date.now();try{const r=InteropGraphqlClient.getRequestConfig({},{validateStatus:()=>true}),s=`${InteropGraphqlClient.getInteropUrl(e)}/ping`,n=await axios_1.default.get(s,r),a=xtrem_date_time_1.Datetime.now(true);return{timestamp:a,duration:a.value-t,status:n.status,statusText:n.statusText,isAlive:200===n.status}}catch(e){const r=xtrem_date_time_1.Datetime.now(true);return{timestamp:r,duration:r.value-t,status:e.response?.status||500,statusText:e.response?.statusText||e.message,isAlive:false}}}}exports.InteropGraphqlClient=InteropGraphqlClient;
//# sourceMappingURL=interop-graphql-client.js.map