/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.interopApp=void 0;const xtrem_config_1=require("@sage/xtrem-config"),xtrem_shared_1=require("@sage/xtrem-shared"),express=require("express"),_=require("lodash"),graphql_1=require("../graphql"),http_1=require("../http"),core_hooks_1=require("../runtime/core-hooks"),security_1=require("../security"),interop_graphql_client_1=require("./interop-graphql-client"),errorMiddleware=(e,r)=>(t,i)=>{i.status(e).send(r)},interopAuthMiddleware=async(e,r,t)=>{const i=(0,security_1.getPeerCertificate)(e);if(i){if(!e.client?.authorized)return interop_graphql_client_1.logger.error("Invalid client certificate: Not authorized."),void r.status(403).send("Invalid client certificate.");if(!i.subjectaltname)return interop_graphql_client_1.logger.error("Invalid client certificate: No Subject Alternative Name."),void r.status(403).send("Invalid client certificate.");const t=i.subjectaltname.split(", ").filter(e=>e.startsWith("DNS:")).map(e=>e.replace("DNS:","")),n=_.uniq(t.map(e=>/^([a-z0-9-]+)-xtrem-service-/.exec(e)?.[1])).map(e=>e?.replace(/-/g,"_")),{apps:o}=xtrem_config_1.ConfigManager.current;if(!o||!n.some(e=>e&&null!=o[e]))return interop_graphql_client_1.logger.error(`Invalid client certificate: No matching app among the DNS names. Expecting one of [${Object.keys(o??{})}] got [${n.join(", ")}]`),void r.status(403).send("Invalid client certificate.")}const n=e.headers.authorization;if(!n)return void r.status(401).send("no Authorization header");const o=/^Bearer\s+(.*)/.exec(n),a=o?.[1];if(!a)return void r.status(401).send("no Bearer token");const s=await interop_graphql_client_1.InteropGraphqlClient.parseBearerToken(a),p=interop_graphql_client_1.InteropGraphqlClient.getScopeUserEmail(s.scope),{tenantId:c}=s;r.locals.auth={...s,login:p},r.locals.config={tenantId:c},t()};function interopApp(e){const r=xtrem_config_1.ConfigManager.current.interop?.graphqlTimeLimitInSeconds||120,t=express();return t.use((0,http_1.requestLoggerMiddleware)(interop_graphql_client_1.logger)),t.get("/ping",(e,r)=>r.json({})),t.use(interopAuthMiddleware),t.use("/api",(0,graphql_1.graphQlApp)(e,{graphqlTimeLimitInSeconds:r})),t.use("/proxy",core_hooks_1.CoreHooks.interopManager.interopProxyMiddleware(e)),t.use(errorMiddleware(404,"not found")),t.use((e,r,t,i)=>{if(e instanceof xtrem_shared_1.BaseError)t.status(200).send({extensions:e.extensions});else i(e)}),t}exports.interopApp=interopApp;
//# sourceMappingURL=interop-app.js.map