import { AuthConfig } from '@sage/xtrem-shared';
import { Express } from 'express';
import { Application } from '../application';
export interface InteropAppInfo {
    name: string;
    title: string;
    isConnector: boolean;
    interopPackage: string;
    isActive: boolean;
}
export interface InteropAuthConfig extends AuthConfig {
    appName: string;
    scope: string;
    sourceUserEmail: string;
    iat: number;
    exp: number;
}
/**
 * Creates an express app that serves the interop API.
 * @param application The application to serve.
 * @returns The express app.
 */
export declare function interopApp(application: Application): Express;
//# sourceMappingURL=interop-app.d.ts.map