/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.NodeQuery=void 0;const xtrem_shared_1=require("@sage/xtrem-shared"),graphql_1=require("graphql"),loggers_1=require("../../runtime/loggers"),paging_1=require("../paging/paging"),access_rights_1=require("../security/access-rights"),get_total_count_1=require("./get-total-count"),logger=loggers_1.loggers.graphQl;class NodeQuery{static makeType(e,r,t){const a=`${t.toString()}_Query`;return e.internType(a,()=>new graphql_1.GraphQLObjectType({name:a,fields:{totalCount:get_total_count_1.GetTotalCount.makeResolver(r),edges:paging_1.Paging.makeEdgesResolver(e,t),pageInfo:paging_1.Paging.makePageInfoResolver()}}))}static resolveNodeQuery(e,r,t,a){return access_rights_1.AccessRights.runSecure(e,"read",{factory:r,args:a},async()=>{const a=await e.query(r.nodeConstructor,{...t,first:t.first&&t.first+1,last:t.last&&t.last+1}).toArray();return paging_1.Paging.buildOutputPage({items:a},t,true)})}static makeResolver(e,r,t){return{type:NodeQuery.makeType(e,r,t),args:paging_1.Paging.getPagingArgumentTypes(),resolve:(e,t,a,s)=>access_rights_1.AccessRights.runSecure(a,"read",{factory:r},async()=>{const e=a;try{const a=await paging_1.Paging.parsePagingOptions(e,r,t,s,r.defaultOrderBy);return{context:e,pagePromise:NodeQuery.resolveNodeQuery(e,r,a,t),pagingOptions:a}}catch(e){throw logger.error(e.stack),new xtrem_shared_1.DataInputError(e.message,e)}})}}}exports.NodeQuery=NodeQuery;
//# sourceMappingURL=node-query.js.map