/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.LookupQuery=void 0;const graphql_1=require("graphql"),paging_1=require("../paging/paging"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type"),lookup_total_count_1=require("./lookup-total-count");class LookupQuery{static makeLookupQueryType(e,o){const r=`${o.toString()}_Lookups_Reference`;return e.internType(r,()=>new graphql_1.GraphQLObjectType({name:r,fields:{totalCount:lookup_total_count_1.LookupTotalCount.makeResolver(),edges:paging_1.Paging.makeEdgesResolver(e,o),pageInfo:paging_1.Paging.makePageInfoResolver()}}))}static async lookupQuery(e,o){const r={...o.pagingOptions,first:o.pagingOptions.first&&o.pagingOptions.first+1,last:o.pagingOptions.last&&o.pagingOptions.last+1};if(!o.lookupArgs._id&&!o.lookupArgs.data)throw new Error(`${o.parentFactory.name}.${o.propertyName}: lookups missing id or data parameter`);if(o.lookupArgs.data)o.lookupArgs.data=await node_type_1.NodeType.nodeValuesIn(e,o.lookupArgs.data,o.parentFactory,{omitNulls:false});const t=await e.makeLookupQueryParameters(o.parentFactory.nodeConstructor,o.propertyName,o.lookupArgs);return e.lookup(t,r).toArray()}static makeResolver(e,o,r,t,a){return{type:LookupQuery.makeLookupQueryType(e,t),args:paging_1.Paging.getPagingArgumentTypes(),resolve:(e,t,p,s)=>access_rights_1.AccessRights.runSecure(p,"lookup",{factory:o,args:t},async()=>{const n={lookupArgs:e,factory:o,parentFactory:r,propertyName:a},g=p,u=await paging_1.Paging.parsePagingOptions(g,o,t,s,o.defaultOrderBy),i=await LookupQuery.lookupQuery(g,{...n,pagingOptions:u});return{context:g,pagePromise:paging_1.Paging.buildOutputPage({items:i},u,true),parentArgs:n}})}}}exports.LookupQuery=LookupQuery;
//# sourceMappingURL=lookup-query.js.map