/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.CreateUpdateMutations=void 0;const graphql_1=require("graphql"),lodash_1=require("lodash"),access_rights_1=require("../security/access-rights"),node_type_1=require("../types/node-type");class CreateUpdateMutations{static makeResolver(e,t,a){return{description:`${(0,lodash_1.capitalize)(a)} a ${t.name}`,type:node_type_1.NodeType.makeOutputType(e,t,"nodeOutput"),args:{_id:{type:graphql_1.GraphQLID},data:{type:node_type_1.NodeType.makeInputType(e,t,"nodeInput")}},resolve:(e,r,i)=>access_rights_1.AccessRights.runSecure(i,a,{factory:t,isMutation:true,operation:"create"===a?a:"update",args:r},()=>i.withChildContext(async e=>{const{dataAtlevel:i,factoryAtlevel:o,keyAtlevel:n,pathAtlevel:s,reversedPathAtlevel:l}=await CreateUpdateMutations.transformVitalChildPayloadToParentPayload(e,t,r.data,[],[]);if(s.length>0)return CreateUpdateMutations.createOrUpdateVitalParent(e,i,o,n,s,l);if("create"===a){const a=await node_type_1.NodeType.nodeIn(e,r.data,t);return await a.$.save(),a}const d=await node_type_1.NodeType.nodeValuesIn(e,r.data,t),p="external"===t.storage?"updateById"===a?{_id:r._id}:(0,lodash_1.pick)(d,[...t.keyProperties.map(e=>e.name),"_id"]):{_id:"updateById"===a?r._id:d._id},u=await e.read(t.nodeConstructor,p,{forUpdate:true});if(null!=d._etag){const t=String(await u.$.etag);if(d._etag!==t)throw e.businessRuleError({key:"@sage/xtrem-core/record-modified-reload-required",message:"Another user made changes to this record. Refresh the page to add your changes."})}return await u.$.set(d),await u.$.save(),u},{isolationLevel:t.getIsolationLevel("create"===a?"create":"update")}))}}static hasVitalParentPayload(e,t){return e.isVitalChild&&e.vitalParentProperty.isVitalParentInput&&null!=t[e.vitalParentProperty.name]&&"object"==typeof t[e.vitalParentProperty.name]&&"sql"===e.storage}static pickKeyPropertiesValueFromPayload(e,t){return t._id?{_id:t._id}:(0,lodash_1.pick)(t,[...e.keyProperties.map(e=>e.name),"_id"])}static async transformVitalChildPayloadToParentPayload(e,t,a,r,i){if(CreateUpdateMutations.hasVitalParentPayload(t,a)){const{vitalParentFactory:o}=t;if(1!==o.properties.filter(e=>e.isReferenceProperty()&&e.targetFactory.name===t.name).length)throw new Error(`Vital parent property ${t.vitalParentProperty.name} must have a unique child property ${t.name}`);const n=await node_type_1.NodeType.nodeValuesIn(e,a[t.vitalParentProperty.name],o),s=CreateUpdateMutations.pickKeyPropertiesValueFromPayload(o,n),l=t.getReverseVitalProperty();if(l){if(n[l.name]=await node_type_1.NodeType.nodeValuesIn(e,(0,lodash_1.omit)(a,t.vitalParentProperty.name),t),r.unshift(l.name),i.unshift(t.vitalParentProperty.name),o.isVitalChild)return CreateUpdateMutations.transformVitalChildPayloadToParentPayload(e,o,n,r,i);return{dataAtlevel:n,factoryAtlevel:o,keyAtlevel:s,pathAtlevel:r,reversedPathAtlevel:i}}}const o=CreateUpdateMutations.pickKeyPropertiesValueFromPayload(t,a);return{dataAtlevel:a,factoryAtlevel:t,keyAtlevel:o,pathAtlevel:r,reversedPathAtlevel:i}}static async createOrUpdateVitalParent(e,t,a,r,i,o){let n=(0,lodash_1.isEmpty)(r)?void 0:await e.tryRead(a.nodeConstructor,r,{forUpdate:true});const s=!!n;try{if(!n)n=await e.create(a.nodeConstructor,t);else await n.$.set(t);return await n.$.save(),await n.$.get(i.join("."))}catch(t){throw CreateUpdateMutations.fixDiagnosesPaths(e,s,i,o),t}}static fixDiagnosesPaths(e,t,a,r){if(a.length>0)e.diagnoses.forEach(e=>{const i=[...e.path],o=i.filter(e=>!a.includes(e)),n=i.findIndex(e=>e===o[0]);e.path=o.length===i.length&&1===r.length?[...i]:[...r.slice(n).reverse(),...o],e.message=t?`[Updating vital parent] ${e.message}`:`[Creating vital parent] ${e.message}`})}}exports.CreateUpdateMutations=CreateUpdateMutations;
//# sourceMappingURL=create-update-mutations.js.map