/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getUserInfoSchemaFragment=void 0;const graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),metrics_1=require("../../metrics"),runtime_1=require("../../runtime"),client_service_1=require("../../system/pages/client-service"),userInfoType=new graphql_1.GraphQLObjectType({name:"_UserInfo",fields:{firstName:{type:graphql_1.GraphQLString},lastName:{type:graphql_1.GraphQLString},userCode:{type:graphql_1.GraphQLString},email:{type:graphql_1.GraphQLString},photo:{type:graphql_1.GraphQLString},bookmarks:{type:new graphql_1.GraphQLList(graphql_1.GraphQLString)},history:{type:new graphql_1.GraphQLList(graphql_1.GraphQLString)},uniqueUserId:{type:graphql_1.GraphQLString},uniqueTenantId:{type:graphql_1.GraphQLString},clientEncryptionKey:{type:graphql_1.GraphQLString}}}),getUserInfoSchemaFragment=()=>({queries:{userInfo:{type:userInfoType,resolve:(e,r,t)=>metrics_1.CustomMetrics.metadata.withMetrics({nodeName:"sitemap",operationName:"read",operationKind:"query"},()=>(0,concurrency_utils_1.runResolver)(t,async()=>{const e=await client_service_1.ClientService.getUniqueUserId(t),r=client_service_1.ClientService.getUniqueTenantId(t),a=await client_service_1.ClientService.getDefaultUserEncryptionKey(t),i=await t.user;if(i){const n=runtime_1.Context.accessRightsManager.getUserNavigation?await runtime_1.Context.accessRightsManager.getUserNavigation(t):{};return{firstName:i.firstName,lastName:i.lastName,userCode:i.userName,email:i.email,history:n.history||[],bookmarks:n.bookmarks||[],photo:i.photo?.value.toString("base64"),clientEncryptionKey:i.clientEncryptionKey||a,uniqueUserId:e,uniqueTenantId:r}}return null}))}}});exports.getUserInfoSchemaFragment=getUserInfoSchemaFragment;
//# sourceMappingURL=user-info-fragment.js.map