/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.getPagesSchemaFragment=void 0;const graphql_1=require("graphql"),concurrency_utils_1=require("../../concurrency-utils"),artifact_manager_1=require("../../system/artifact-manager"),client_service_1=require("../../system/pages/client-service"),util_1=require("../../types/util"),basic_types_1=require("../types/basic-types"),metadata_schema_utils_1=require("./metadata-schema-utils"),node_details_fragment_1=require("./node-details-fragment"),duplicateBindingsType=new graphql_1.GraphQLList(graphql_1.GraphQLString),customizableNodeType=new graphql_1.GraphQLObjectType({name:"_MetaCustomizableNode",fields:{node:{type:graphql_1.GraphQLString},fullName:{type:graphql_1.GraphQLString}}}),customizableNodesType=new graphql_1.GraphQLList(customizableNodeType),customFieldType=new graphql_1.GraphQLObjectType({name:"_MetaCustomField",fields:{name:{type:graphql_1.GraphQLString},dataType:{type:graphql_1.GraphQLString},targetNodeName:{type:graphql_1.GraphQLString},componentType:{type:graphql_1.GraphQLString},anchorPropertyName:{type:graphql_1.GraphQLString},anchorPosition:{type:graphql_1.GraphQLString},destinationTypes:{type:new graphql_1.GraphQLList(graphql_1.GraphQLString)},componentAttributes:{type:graphql_1.GraphQLString}}}),customFieldsType=new graphql_1.GraphQLList(customFieldType),customNodeType=new graphql_1.GraphQLObjectType({name:"_MetaCustomNode",fields:{name:{type:graphql_1.GraphQLString},properties:{type:customFieldsType}}}),exportTemplateType=new graphql_1.GraphQLObjectType({name:"_MetaExportTemplateType",fields:{id:{type:graphql_1.GraphQLString},name:{type:graphql_1.GraphQLString},isDefault:{type:graphql_1.GraphQLBoolean}}}),nodeExportTemplateType=new graphql_1.GraphQLObjectType({name:"_MetaNodeExportTemplateType",fields:{name:{type:graphql_1.GraphQLString},exportTemplates:{type:new graphql_1.GraphQLList(exportTemplateType)}}}),userSetting=new graphql_1.GraphQLObjectType({name:"_MetaUserSetting",fields:{_id:{type:graphql_1.GraphQLString},content:{type:basic_types_1.jsonType},elementId:{type:graphql_1.GraphQLString},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString}}}),customNodesType=new graphql_1.GraphQLList(customNodeType),exportTemplatesType=new graphql_1.GraphQLList(nodeExportTemplateType),userSettingList=new graphql_1.GraphQLList(userSetting),pageType=new graphql_1.GraphQLObjectType({name:"_Page",fields:{key:{type:graphql_1.GraphQLString},title:(0,metadata_schema_utils_1.getArtifactTitleConfig)(client_service_1.ClientArtifactType.pages),content:{type:graphql_1.GraphQLString,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>e?e.content.toString():"")},category:{type:graphql_1.GraphQLString},extensions:{type:metadata_schema_utils_1.extensionsType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,async()=>(await artifact_manager_1.ArtifactManager.getExtensionsForPage(a,e.key,client_service_1.ClientArtifactType.pages)).map(e=>e.content.toString()))},fragments:{type:metadata_schema_utils_1.fragmentsType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,async()=>{const t=await artifact_manager_1.ArtifactManager.getArtifactPageFragments(a,e);return Object.values(t).map(e=>({name:e.key,content:e.content.toString()}))})},plugins:{type:metadata_schema_utils_1.pluginsType},strings:(0,metadata_schema_utils_1.getArtifactStringsConfig)(client_service_1.ClientArtifactType.pages),access:{type:metadata_schema_utils_1.accessListType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.resolveAccess(a,e))},pageAccess:{type:graphql_1.GraphQLString,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.resolvePageAccess(a,e))},pageNode:{type:graphql_1.GraphQLString},customFields:{type:customNodesType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.resolvePageCustomFields(a,e))},exportTemplatesByNode:{type:exportTemplatesType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.resolvePageExportTemplatesByNode(a,e))},duplicateBindings:{type:duplicateBindingsType},customizableNodes:{type:customizableNodesType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.resolvePageCustomizableNodes(a,e))},customizableNodesWizard:{type:customizableNodesType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>artifact_manager_1.ArtifactManager.resolvePageCustomizableNodesWizard(a,e))},activeUserSettings:{type:userSettingList,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>{const t=e.key.split("/")[2];return a.application.clientSettingsManager.getActiveClientSettingsForArtifact(a,t)})},nodeDetails:{type:node_details_fragment_1.nodeDetailsListType,args:{knownNodeNames:{type:new graphql_1.GraphQLList(graphql_1.GraphQLString)}},resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,async()=>{const r=await artifact_manager_1.ArtifactManager.getArtifactNodes(a,e);if(0===r.length)return[];const n=r.map(util_1.getNameWithoutPackage);return(0,node_details_fragment_1.resolveNodeDetailsList)(a,{missingNodeNames:n,knownNodeNames:t.knownNodeNames??[],depth:3})})},nodeCustomDetails:{type:node_details_fragment_1.nodeCustomDetailsListType,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,async()=>{const r=await artifact_manager_1.ArtifactManager.getArtifactNodes(a,e);if(0===r.length)return[];const n=r.map(util_1.getNameWithoutPackage);return(0,node_details_fragment_1.resolveNodeCustomDetailsList)(a,{missingNodeNames:n,knownNodeNames:t.knownNodeNames??[],depth:3})})}}}),updateUserClientSetting={type:userSetting,args:{_id:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},content:{type:basic_types_1.jsonType},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString}},resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>a.application.requestFunnel(()=>a.withChildContext(e=>e.application.clientSettingsManager.updateClientSetting(e,t._id,t.content,t.title||"",t.description||""),{isolationLevel:"low"})))},createUserClientSetting={type:userSetting,args:{screenId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},elementId:{type:new graphql_1.GraphQLNonNull(graphql_1.GraphQLString)},content:{type:basic_types_1.jsonType},title:{type:graphql_1.GraphQLString},description:{type:graphql_1.GraphQLString}},resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>a.application.requestFunnel(()=>a.withChildContext(e=>e.application.clientSettingsManager.createClientSetting(e,t.screenId,t.elementId,t.content,t.title||"",t.description||""),{isolationLevel:"low"})))},resetClientSettings={type:graphql_1.GraphQLBoolean,resolve:(e,t,a)=>(0,concurrency_utils_1.runResolver)(a,()=>a.application.requestFunnel(()=>a.withChildContext(e=>e.application.clientSettingsManager.resetClientSettings(e),{isolationLevel:"low"})))},pagesType=new graphql_1.GraphQLList(pageType),getPagesSchemaFragment=e=>({queries:{pages:{type:pagesType,args:metadata_schema_utils_1.pagesArgsWithFilter,resolve:(0,metadata_schema_utils_1.resolveArtifact)(e,client_service_1.ClientArtifactType.pages)}},mutations:{updateUserClientSetting,createUserClientSetting,resetClientSettings}});exports.getPagesSchemaFragment=getPagesSchemaFragment;
//# sourceMappingURL=pages-fragment.js.map