/// <reference types="@sage/xtrem-log" />
/** @ignore */ /** */
import { AnyValue, AsyncResponse } from '@sage/xtrem-async-helper';
/** Global cache module
 * To use:
 *
 *      const cachedValue = application.globalCache.getValue<MyType>(
 *          context,
 *          {
 *              category: myCategory,
 *              key: myKey,
 *              getValue: getValueCallback,
 *              cacheInMemory: true,
 *              ttlInSeconds: 5 * 60,
 *           }
 *      );
 *
 * If the key is not in the cache, `getValueCallback` will be invoked to obtain the value.
 * The value will then be cached, according to the provided options
 * (here, the value will be cached for 5 minutes in memory and database).
 *
 *
 *  `getValueCallback` has the following signature: `() => { value: MyType, invalidatingTokens?: string[] }`
 *  where `value` is the value and invalidatingTokens is an optional list of tokens that may invalidate the cached result.
 *
 * `MyType` can usually be omitted. It will be inferred from `getValue`.
 */
export declare const logger: import("@sage/xtrem-log/lib/logger").Logger;
export type GetValueCallback<T extends AnyValue> = () => AsyncResponse<{
    value: T;
    invalidatingTokens?: string[];
}>;
export interface GlobalCacheOptions<T extends AnyValue> {
    category: string;
    key: string;
    getValue: GetValueCallback<T>;
    /** should the value be written to the context cache? */
    isolateInContext?: boolean;
    /** should the value be written to the in-memory cache? */
    cacheInMemory?: boolean;
    /** The TTL of the value (value will never expire if TTL is not set) */
    ttlInSeconds: number;
}
//# sourceMappingURL=global-cache.d.ts.map