/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.S3Manager=void 0;const xtrem_async_helper_1=require("@sage/xtrem-async-helper"),xtrem_config_1=require("@sage/xtrem-config"),child_process_1=require("child_process"),fs=require("fs"),os=require("os"),fsp=require("path"),readline=require("readline"),semver=require("semver"),application_1=require("../application"),archive_1=require("../archive"),context_1=require("../runtime/context"),loggers_1=require("../runtime/loggers"),database_sql_context_1=require("../sql/sql-context/database-sql-context"),schema_sql_context_1=require("../sql/sql-context/schema-sql-context"),check_recompute_values_hash_1=require("../utils/check-recompute-values-hash"),s3_helper_1=require("./s3-helper"),logger=loggers_1.loggers.aws,s3Configurations={forSqlFiles:{bucket:"xtrem-developers-utility",folder:"backupsForSqlFiles",getFullFolder(e){return`${this.folder}/${e.name}`}},clusterCuBackup:{bucket:"xtrem-developers-utility",folder:"dev-eu-cls-cu-backups-result/sdmo",s3Key:"xtrem-cls-cu-sdmo-current.gz"},clusterCiBackup:{bucket:"xtrem-developers-utility",folder:"dev-eu-cluster-ci-backups-result",s3Key:"xtrem-cluster-ci-latestWorking.gz"},clusterCiSdmo:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/sdmo",s3Key:"xtrem-ci-v2-sdmo-latestWorking.gz"},clusterReference:{bucket:"xtrem-developers-utility",folder:"dev-eu-cls-ref-backups-result/sdmo",s3Key:"xtrem-cls-ref-sdmo-latest.gz"},clusterDevRelease:{bucket:"xtrem-developers-utility",folder:"dev-eu-cls-release-backups-result/sdmo",s3Key:"xtrem-cls-release-sdmo-latest.gz"},clusterQaRelease:{bucket:"xtrem-developers-utility",folder:"qa-na-cluster-release-backups-result",s3Key:"xtrem-qa-na-cluster-release-latest.gz"},glossary:{bucket:"xtrem-developers-utility",folder:"dev-eu-glossary-backups-result",s3Key:"xtrem-glossary-latestWorking.gz"},showcase:{bucket:"xtrem-developers-utility",folder:"dev-eu-showcase-backups-result",s3Key:"xtrem-dev-eu-showcase-latestWorking.gz"},shopfloor:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/shopfloor",s3Key:"xtrem-ci-v2-shopfloor-latestWorking.gz"},x3_connector:{bucket:"xtrem-developers-utility",folder:"dev-eu-ci-v2-backups-result/x3-connector",s3Key:"xtrem-ci-v2-x3-connector-latestWorking.gz"}},createRole=["DO $$$$","BEGIN","CREATE ROLE xtrem WITH NOLOGIN;","EXCEPTION WHEN DUPLICATE_OBJECT THEN","RAISE NOTICE 'not creating role xtrem -- it already exists';","END","$$$$;","",""].join("\n");class S3Manager{static{this._postgreSqlTools={isCi:false,version:"",image:""}}static async dumpSchemaToS3Bucket(e){const r=await e.packageManager.getCurrentVersion(e.mainPackage)||"0.0.0";logger.info(`Upload database schema ${e.name}@${r} to s3://${s3Configurations.forSqlFiles.bucket}`);const t=os.tmpdir(),s=`${e.shortName}@${r}.zip`,o=S3Manager._normalizeApplicationName(s),a=fsp.join(t,o);await S3Manager.dumpSchemaToFile(t,o,e.schemaName);try{const r=await S3Manager.uploadDumpToS3(e,t,o,s);return logger.info(()=>`The db dump was uploaded to ${r}`),r}finally{if(logger.verbose(()=>`Delete temp file ${a}`),fs.existsSync(o))fs.unlinkSync(a)}}static _getFullS3Folder(e,r){return null==r.getFullFolder?r.folder:r.getFullFolder(e)}static async _resolveVersionToRestoreForSqlFiles(e,r){const t=s3Configurations.forSqlFiles;if((""===r||"latest"===r)&&!t.s3Key){const t=await S3Manager.getAvailableVersions(e);if(0===t.length)await S3Manager._raiseErrorVersionNotFoundForSqlFile(e,r,t);const s=t[0];return logger.info(`'latest' was resolved as ${s}`),s}return r}static async _raiseErrorVersionNotFoundForSqlFile(e,r,t){const s=t||await S3Manager.getAvailableVersions(e);let o=`No version '${r||"latest"}' could be found for application ${e.name}@${e.version}`;const a="\n\t- ";if(t?.length)o=`${o}, compatible versions are:${a}${s.join(a)}`;throw new Error(o)}static async restoreSchemaFromS3Bucket(e,r,t="forSqlFiles",s={checkSingleSchema:false}){const o=os.tmpdir();let a,n,i,l=true,c=false;if(r.startsWith("file://"))i=r.substring(7),l=false,n=`Successfully restored from local file ${i}`,c=true;else{if(r.startsWith("s3://"))a=await S3Manager._downloadDumpFileFromS3ObjectInfo(s3_helper_1.S3Helper.parseS3Uri(r),o),n=`Successfully restored ${r}`,c=true;else{const s=s3Configurations[t];if(!s)throw new Error(`Invalid configuration: ${t}`);let i;if("forSqlFiles"===t)i=await S3Manager._resolveVersionToRestoreForSqlFiles(e,r);else i=r;logger.info(`[${e.schemaName}] restore ${e.name}@${i} from s3://${s.bucket}/${s.folder}`);const l=s.s3Key||`${e.shortName}@${i}.zip`;if(!await s3_helper_1.S3Helper.objectExists({bucketName:s.bucket,folder:S3Manager._getFullS3Folder(e,s),key:l})){const r=await S3Manager.getAvailableVersions(e);await S3Manager._raiseErrorVersionNotFoundForSqlFile(e,i,r)}a=await S3Manager._downloadDumpFileFromS3Key(e,o,l,t),n=`Successfully restored ${e.name}@${i}`}i=fsp.join(o,a)}try{if(await S3Manager._restoreSchemaFromFile(e,o,i,"clusterCiBackup"===t||"clusterCiSdmo"===t||i.includes(s3Configurations.clusterCiBackup.s3Key)||i.includes(s3Configurations.clusterCiSdmo.s3Key)),c){let r=[];await e.asRoot.withReadonlyContext(null,async e=>{r=await context_1.Context.tenantManager.listTenantsIds(e)},{source:"customMutation"}),await(0,xtrem_async_helper_1.asyncArray)(r).forEach(async r=>{await(0,check_recompute_values_hash_1.checkAndSyncValuesHash)(e,r,logger)})}}finally{if(l)if(logger.verbose(()=>`Delete temp file ${i}`),fs.existsSync(i))fs.unlinkSync(i)}await S3Manager._listSchemas(e,s.checkSingleSchema),logger.info(n)}static async _listSchemas(e,r){const t=(await e.createContextForDdl(e=>e.executeSql("select nspname name from pg_catalog.pg_namespace",[]))).map(e=>e.name).filter(e=>{if(e.startsWith("pg_"))return false;if("information_schema"===e)return false;if("public"===e)return false;return true});if(logger.info(`Schemas in the database: ${t.join(", ")}`),r&&1!==t.length)throw new Error(`Expected a single schema, found ${t.length}`)}static uploadDumpToS3(e,r,t,s){return S3Manager._uploadLocalFileToS3(e,s3Configurations.forSqlFiles,fsp.join(r,t),s)}static _uploadLocalFileToS3(e,r,t,s){const o={bucketName:r.bucket,folder:S3Manager._getFullS3Folder(e,r),key:s};return logger.verbose(()=>`Upload ${t} to ${s3_helper_1.S3Helper.buildS3Uri(o)}`),s3_helper_1.S3Helper.upload(t,o)}static _isBackupForSqlFile(e,r){return r.startsWith(`${e.shortName}@`)}static async getAvailableVersions(e){const r=semver.major(e.mainPackage.packageJson.version);return(await S3Manager._listS3BackupsForSqlFile(e,s3Configurations.forSqlFiles.bucket)).map(e=>S3Manager._getVersionFromS3Key(e)).filter(e=>semver.major(e)===r).sort(semver.compare).reverse()}static _getVersionFromS3Key(e){const r=e.lastIndexOf("@"),t=e.lastIndexOf(".");return e.substring(r+1,t)}static async _listS3BackupsForSqlFile(e,r){const t=s3Configurations.forSqlFiles,s=S3Manager._getFullS3Folder(e,t);logger.verbose(()=>`Looking for versions compatible with ${e.name}@${e.version} from s3://${r}/${s}`);const o=await s3_helper_1.S3Helper.listObjects({bucketName:r,folder:s,key:""});if(!o)return[];return o.map(r=>{if(null==r.key)return null;if(!r.key.startsWith(`${s}/`))return null;const t=r.key.substring(s.length+1);if(!S3Manager._isBackupForSqlFile(e,t))return null;return t}).filter(e=>e)}static async _downloadDumpFileFromS3ObjectInfo(e,r){const t=S3Manager._normalizeApplicationName(e.key),s=fsp.join(r,t);return logger.info(()=>`Download ${s3_helper_1.S3Helper.buildS3Uri(e)} to ${s}`),await s3_helper_1.S3Helper.download(e,s),t}static _downloadDumpFileFromS3Key(e,r,t,s){const o=s3Configurations[s];if(!o)throw new Error("Invalid S3 config key passed");const a={bucketName:o.bucket,folder:S3Manager._getFullS3Folder(e,o),key:t};return S3Manager._downloadDumpFileFromS3ObjectInfo(a,r)}static _tailLogLine(e){if(e.endsWith("\n"))return e.substring(0,e.length-1);return e}static async _pipeStreamWithTransformations(e){const formatSize=e=>{if(e>=1048576)return`${(e/1048576).toFixed(2)} MB`;if(e>=1024)return`${(e/1024).toFixed(2)} KB`;return`${e} bytes`};await new Promise((r,t)=>{const s=readline.createInterface({input:e.inData,crlfDelay:1/0});let o=true,a=0,n=0,i="",l=false;const handleError=r=>{logger.error(`Transformation error: ${r.message}`),logger.info(`Processed ${n} lines.\nLast line read: ${i}`),l=true,e.outStream.destroy(),t(r)};if(s.on("error",handleError),e.outStream.on("error",handleError),e.inErr)e.inErr.on("data",e=>{const r=e.toString();logger.error(`ERR ${S3Manager._tailLogLine(r)}`)}),e.inErr.on("error",handleError);s.on("line",r=>{if(i=r,e.mappings.forEach(({reg:e,val:r})=>{i=i.replace(e,r)}),o=e.outStream.write(`${i}\n`),!o)s.pause();n++,a=Math.max(a,i.length),logger.debug(()=>`\t${S3Manager._tailLogLine(r)}`)}),e.outStream.on("drain",()=>{s.resume()}),s.on("close",()=>{e.outStream.end(),logger.info(`Transformation finished processing ${n} lines.\nMax line length encountered: ${formatSize(a)}`)}),e.outStream.on("finish",()=>{if(!l)r()}),e.inMain.on("close",r=>{if(![0,e.expectedExitCode].includes(r))handleError(new Error(`Exited with code ${r}`))})})}static _pgClientToolCommand(e,r,t){const s=xtrem_config_1.ConfigManager.current,o={isCi:!!s.env?.isCI,version:"16.1",image:"postgres:16.1-alpine"};let a=[];if(!this._postgreSqlTools.version){const e=/^psql\s+\(\w+\)\s+(\d+\.\d+)/,r=">=16.1",t=`Please, install a version ${r}.\non Ubuntu systems you can do it with:\nsudo apt update\nsudo apt install postgresql-client`;if(a=["psql","--version"],o.isCi){const r=(0,child_process_1.spawnSync)("docker",["exec","-i","xtrem_postgres","psql","--version"],{encoding:"utf-8"});if(null!=r.error)throw new Error(`Cannot get image version of xtrem_postgres. ${t}`);o.version=e.exec(r.stdout)?.[1]??"",o.image=`postgres:${o.version}-alpine`,logger.info(`Use PostgreSQL client tools version ${o.version} from image ${o.image}`),a=["docker","run","-i","--rm",o.image,...a]}const s=(0,child_process_1.spawnSync)(a[0],a.slice(1),{encoding:"utf-8"});if(null!=s.error)throw new Error(`Cannot get PostgreSQL client tools version. ${t}`);o.version=e.exec(s.stdout)?.[1]??"";const n=semver.coerce(o.version);if(null==n)throw new Error(`Cannot get PostgreSQL client tools version. The version ${s.stdout} does not have the expected format. ${t}`);if(!semver.satisfies(n,r))throw new Error(`PostgreSQL client tools version ${n} does not satisfies the expected version ${r}. ${t}`);this._postgreSqlTools=o}const n=os.tmpdir();if(a=[e,...r],o.isCi)a=["docker","run","-i","--rm","-v",`${n}:/tmp`,"-e",`PGPASSWORD=${t?.env?.PGPASSWORD}`,o.image,e,...r.map(e=>e.replace(n,"/tmp").replace("localhost","172.17.0.1").replace("127.0.0.1","172.17.0.1"))];return(0,child_process_1.spawn)(a[0],a.slice(1),t)}static async dumpSchemaToFile(e,r,t){const s=r.endsWith(".zip"),o=s?"sql.dump":r,a=fsp.join(e,o),n=xtrem_config_1.ConfigManager.current.storage?.sql;logger.verbose(()=>`Dump ${n.database}.${t} to ${a}`);const i=["--format=p",`--host=${n.hostname}`,`--dbname=${n.database}`,`--schema=${t}`,`--username=${n.user}`,"--no-password"],l=this._pgClientToolCommand("pg_dump",i,{env:{...process.env,PGPASSWORD:n.password},cwd:e});await S3Manager._pipeStreamWithTransformations({inData:l.stdout,inErr:l.stderr,inMain:l,outStream:fs.createWriteStream(a),mappings:[{reg:new RegExp(` SCHEMA ${t}`,"g"),val:" SCHEMA [SCHEMA_NAME]"},{reg:new RegExp(`${t}\\.`,"g"),val:"[SCHEMA_NAME]."},{reg:new RegExp(` TO ${n.user};`,"g"),val:" TO [USER_NAME];"},{reg:/ALTER DEFAULT PRIVILEGES FOR ROLE xtrem/,val:`${createRole}ALTER DEFAULT PRIVILEGES FOR ROLE xtrem`}],expectedExitCode:0});const c=fsp.join(e,r);if(s)if(logger.verbose(()=>`Zip ${a} to ${c}`),await archive_1.Compress.zipFile(a,o,c,{zlib:{level:9}}),logger.debug(()=>`Deleting temp file ${a}`),fs.existsSync(a))fs.unlinkSync(a)}static _getMappingsForDumpFiles(e,r,t){const s=[{reg:/\[SCHEMA_NAME\]/g,val:e},{reg:/\[USER_NAME\]/g,val:t.user}],o=fs.openSync(r,"r");try{const e=1e3,r=Buffer.alloc(e),a=fs.readSync(o,r);if(a!==e)return logger.warn(`\t- could only get ${a} out of ${e} first chars of the SQL file`),s;const n=r.toString().match(/^-- Name: \S+; Type: SCHEMA; Schema: \S+; Owner: (\S+)$/m);if(n&&t.user!==n[1])logger.info(`\t- will remap user '${n[1]}' to '${t.user}'`),s.push({reg:new RegExp(` OWNER TO ${n[1]};$`,"gm"),val:` OWNER TO ${t.user};`})}catch(e){logger.warn(`\t- encountered error ${e.message} while building mappings to apply to the SQL file`)}finally{fs.closeSync(o)}return s}static async restoreFromDumpFile(e,r,t){const s=xtrem_config_1.ConfigManager.current.storage?.sql;logger.verbose(()=>`Restore ${s.database}.${t} from ${r}`);const o=fsp.join(e,"sql.mapped.dump");logger.info(()=>`[${t}] transform ${r} to ${o}`);const a=S3Manager._getMappingsForDumpFiles(t,r,s),n=fs.createReadStream(r);if(await S3Manager._pipeStreamWithTransformations({inData:n,inMain:n,outStream:fs.createWriteStream(o),mappings:a,expectedExitCode:void 0}),logger.info(()=>`Delete original dump file ${r} after transformation`),fs.existsSync(r))fs.unlinkSync(r);logger.info(()=>`[${t}] restore schema from ${o}`);const i=[`--host=${s.hostname}`,`--dbname=${s.database}`,`--username=${s.sysUser}`,`--file=${o}`,"--single-transaction"];if(void 0!==s.port)i.push("--port"),i.push(`${s.port}`);const l=this._pgClientToolCommand("psql",i,{env:{...process.env,PGPASSWORD:s.sysPassword},cwd:e});if(await S3Manager._childProcessHandler(l,{hackForClusterCi:false}),fs.existsSync(o))fs.unlinkSync(o)}static async _restoreSchemaFromZip(e,r,t){await S3Manager._dropSchemasBeforeRestoration(e,[e.schemaName]),logger.info(()=>`Unzip ${t} to folder ${r}`);const s=await archive_1.Decompress.decompressZipToFolder(t,r);if(logger.info(()=>`Delete archive ${t} after extract`),fs.existsSync(t))fs.unlinkSync(t);const o=s.filter(e=>e.endsWith(".sql")||e.endsWith(".dump"));if(0===o.length)throw new Error(`The archive ${t} does not contain any dump to restore`);if(o.length>1)throw new Error(`The archive ${t} must contain only ONE dump to restore`);const a=fsp.join(r,o[0]);await this.restoreFromDumpFile(r,a,e.schemaName)}static async _restoreSchemaFromBackup(e,r,t,s=false){const o=xtrem_config_1.ConfigManager.current.storage?.sql,a=await S3Manager._processTableOfContentsForRestoration(t);if(logger.info(()=>`The dump concerns the following schemas : ${a.schemas}`),!a.schemas.includes(e.schemaName))logger.warn(()=>`Your configuration is using the schema ${e.schemaName} which will not be restored by this backup`);if(e.schemaName!==application_1.ApplicationManager.getDefaultServiceSchemaName())switch(a.schemas.length){case 0:logger.warn(()=>"The dump does not contain any data/metadata for any schema");break;case 1:if(a.schemas[0]!==e.schemaName)logger.warn(()=>`The dump will be restored to the schema '${a.schemas[0]}' (forced schema '${e.schemaName}' will be ignored)`);break;default:if(!a.schemas.includes(e.schemaName))logger.warn(()=>`The dump concerns many schemas but none of them matches the schema ${e.schemaName}`)}await S3Manager._dropSchemasBeforeRestoration(e,a.schemas);const n=["-L",a.filename,"--host",o.hostname,"--username",o.sysUser??"","--dbname",o.database??"",t,"--no-owner","--no-privileges"];if(void 0!==o.port)n.push("--port"),n.push(`${o.port}`);const i=this._pgClientToolCommand("pg_restore",n,{env:{...process.env,PGPASSWORD:o.sysPassword},cwd:r});if(await S3Manager._childProcessHandler(i,{hackForClusterCi:s}),o.user!==o.sysUser)await(0,xtrem_async_helper_1.asyncArray)(a.schemas).forEach(async e=>{await(new database_sql_context_1.DatabaseSqlContext).setUserDefaultPrivileges(e),await(new database_sql_context_1.DatabaseSqlContext).setUserPrivileges(e)})}static async _processTableOfContentsForRestoration(e){const generateTempFilename=async()=>{const e=await fs.promises.mkdtemp(`${os.tmpdir()}${fsp.sep}`);return fsp.join(e,"pg_restore_without_extenstion_comments.list")},r={filename:await generateTempFilename(),schemas:[]};await S3Manager._childProcessHandler(this._pgClientToolCommand("pg_restore",["--version"]),{hackForClusterCi:false,stdoutCallback:e=>{logger.info(`pg_restore.version=${e}`)}});let t="";await S3Manager._childProcessHandler(this._pgClientToolCommand("pg_restore",["-l",e]),{hackForClusterCi:false,stdoutCallback:e=>{t=`${t}${e}`}}),t=t.replace(/(\d+; \d+ \d+ COMMENT - EXTENSION)/g,";$1");const s=[...t.matchAll(/\d+; \d+ \d+ SCHEMA - (\w+)/g)];if(s)r.schemas=s.map(e=>e[1]).filter(e=>"public"!==e);return fs.writeFileSync(r.filename,t),r}static _dropSchemasBeforeRestoration(e,r){return e.createContextForDdl(e=>(0,xtrem_async_helper_1.asyncArray)(r).forEach(r=>(logger.verbose(()=>`Drop schema (if exists) ${r}`),new schema_sql_context_1.SchemaSqlContext(e.application).dropSchema(r))),{description:()=>`Drop schemas ${r.join()}`})}static async _restoreSchemaFromFile(e,r,t,s=false){if(/\.(zip)$/.test(t))await S3Manager._restoreSchemaFromZip(e,r,t);else if(/\.(gz)$/.test(t))await S3Manager._restoreSchemaFromBackup(e,r,t,s);else throw new Error(`${t}: invalid file type`)}static async _childProcessHandler(e,r){let t=0;await new Promise((s,o)=>{e.stdout.on("data",e=>{if(r.stdoutCallback)r.stdoutCallback(e.toString());else logger.debug(()=>e.toString())}),e.stderr.on("data",e=>{const s=e.toString();if(r.hackForClusterCi){if(["plv8","errors ignored on restore: 1",'relation "lock_monitor" already exists'].some(e=>s.includes(e)))return}if(s.includes("ERROR:"))t+=1;logger.error(s)}),e.on("close",e=>{if(0===e&&0===t)return void s();if(r.hackForClusterCi&&1===e)return void s();const a=`process exited with code ${e}, ${t} errors`;logger.error(a),o(new Error(a))})})}static _normalizeApplicationName(e){return e.replace(/@/g,"").replace(/[/,\\]/g,"-")}}exports.S3Manager=S3Manager;
//# sourceMappingURL=s3-manager.js.map