import type { Context } from '../runtime/context';
export interface ClientUserSettings {
    _id: string | number;
    title: Promise<string>;
    elementId: Promise<string>;
    description?: Promise<string>;
    content?: Promise<string>;
    isSelected?: Promise<boolean>;
}
export interface ClientSettings {
    title: string;
    description: string;
    content: string;
}
export interface ClientSettingsManager {
    getActiveClientSettingsForArtifact(context: Context, artifactId: string): Promise<ClientUserSettings[]>;
    getVariantsForElement(context: Context, artifactId: string, elementId: string): Promise<ClientUserSettings[]>;
    createClientSetting(context: Context, artifactId: string, elementId: string, content: string, title: string, description?: string): Promise<ClientUserSettings>;
    updateClientSetting(context: Context, _id: string, content: string, title: string, description?: string): Promise<ClientUserSettings>;
    selectClientSetting(context: Context, artifactId: string, elementId: string, _id: string): Promise<ClientUserSettings>;
    resetClientSettings(context: Context): Promise<boolean>;
}
export declare class ClientSettingsManagerStub implements ClientSettingsManager {
    resetClientSettings(): Promise<boolean>;
    createClientSetting(): Promise<ClientUserSettings>;
    getActiveClientSettingsForArtifact(): Promise<ClientUserSettings[]>;
    getVariantsForElement(): Promise<ClientUserSettings[]>;
    updateClientSetting(): Promise<ClientUserSettings>;
    selectClientSetting(): Promise<ClientUserSettings>;
}
//# sourceMappingURL=client-settings-manager.d.ts.map