/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ApplicationManager=void 0;const xtrem_config_1=require("@sage/xtrem-config"),fsp=require("path"),security_1=require("../security"),test_1=require("../test"),application_1=require("./application");class ApplicationManager{static{this.applicationCache={}}static getBuildDir(e){const t=require(fsp.resolve(e,"package.json"));let i=t.main?t.main:"build/index.js";if(!t.main&&!t.xtrem&&"production"===xtrem_config_1.ConfigManager.current.deploymentMode){const a=Object.keys(t.dependencies).filter(e=>e.startsWith("@sage/"));if(a.length>1)throw new Error("Production environment should only have one @sage package dependency");const n=a[0];i=fsp.resolve(e,"node_modules",n,"build/index.js")}return fsp.dirname(fsp.resolve(e,i))}static getDefaultServiceSchemaName(){const e=xtrem_config_1.ConfigManager.current;switch(e.deploymentMode){case"development":case"production":return e.app??"xtrem";default:throw new Error(`invalid deployment mode: ${e.deploymentMode}`)}}static getSchemaName(e,t){const i=process.env.XTREM_SCHEMA_NAME;if(i)return i;return"test"===t?test_1.Test.getTestSchemaName(e):this.getDefaultServiceSchemaName()}static async getApplication(e,t){const i=process.env.XTREM_WORKER_ID,a=i?`${i}~${e}`:e;if(this.applicationCache[a])return this.applicationCache[a];await(0,security_1.setup)();const n=this.getBuildDir(e),r=new application_1.Application({buildDir:n,...t,schemaName:this.getSchemaName(n,t?.applicationType)});return this.applicationCache[a]=r,r}}exports.ApplicationManager=ApplicationManager;
//# sourceMappingURL=application-manager.js.map