/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.ActivityManager=void 0;const loggers_1=require("../runtime/loggers"),logger=loggers_1.loggers.authorization;class ActivityManager{#e;constructor(e){this.application=e,this._activities={},this.#e=new Set,this.#t=false}createActivities(e){Object.keys(e.activities).forEach(t=>{if(this._activities[t])return void logger.error(`Activity ${t} is declared more than once in the application and will be ignored in package ${e.name}.`);this._activities[t]=e.activities[t],this._activities[t].package=e.name}),this.mergeActivityExtensions(e)}mergeActivityExtensions(e){Object.keys(e.activitiesExtensions).forEach(t=>{const i=e.activitiesExtensions[t],s=Object.values(this._activities).indexOf(i.extends),a=Object.keys(this._activities)[s];if(this._activities[a])this._activities[a].mergeExtension(i);else throw new Error(`${i.filename}, activity linked to activity extension is not loaded on application.`)})}getActivities(){return this._activities}isNodeAccessControlled(e){return this.#e.has(e)}static checkOperation(e,t,i){let s=false;const checkFactoryOperation=(e,t)=>{if(e[t])return true;return e.isVitalChild&&checkFactoryOperation(e.vitalParentFactory,t)};switch(e){case"lookup":s=true;break;case"read":s=checkFactoryOperation(t,"canRead");break;case"create":s=checkFactoryOperation(t,"canCreate");break;case"update":s=checkFactoryOperation(t,"canUpdate");break;case"delete":s=checkFactoryOperation(t,"canDelete");break;case"import":s=checkFactoryOperation(t,"canCreate")||checkFactoryOperation(t,"canUpdate");break;default:s=t.mutations.some(t=>t.name===e)||t.queries.some(t=>t.name===e)}if(!s&&i?.throws)throw new Error(`Invalid operation granted on Node ${t.name}, ${e} not allowed or not found.`);return s}fillGrants(){Object.values(this._activities).forEach(e=>{e.fillInternalGrants(this.application)}),Object.values(this._activities).forEach(e=>{this.#e.add(e.node.name),Object.values(e.internalGrants).forEach(e=>{Object.values(e).forEach(e=>{if(e.isOperationGrant())this.#e.add(e.node)})})});const e={};Object.values(this._activities).forEach(t=>{let i=t.fillInheritedInternalGrants(this.application,e);for(;i;)i=t.fillInheritedInternalGrants(this.application,e)});let t=true;for(;t;)t=false,Object.values(this._activities).forEach(e=>{Object.keys(e.internalGrants).forEach(i=>{Object.values(e.internalGrants[i]).filter(e=>e.isPermissionGrant()).forEach(s=>{if(s.isPermissionGrant()){const a=this._activities[s.activity],r=a?.internalGrants[s.permission]||{};Object.values(r).forEach(s=>{if(s.isOperationGrant())t=e.addGrant(i,s)})}})})});logger.info(`Filled grants of ${Object.keys(this._activities).length} activities`)}flattenPermissions(){let e=0;Object.keys(this._activities).forEach(t=>{const i=this._activities[t],s={};Object.entries(i.internalGrants).forEach(([t,i])=>{const a={};Object.values(i).forEach(e=>{if(e.isOperationGrant()){const t=e.node,i=this.application.getFactoryByName(t);if(ActivityManager.checkOperation(e.operation,i)){if(!a[e.operation])a[e.operation]=[];if(!a[e.operation].includes(t))a[e.operation].push(t)}}}),s[t]=a,e++}),i.flattenedPermissions=s}),logger.info(`Flatten ${e} permissions among ${Object.keys(this._activities).length} activities`)}#t;resolvePermissions(){if(!this.#t){this.#t=true;let e=logger.verbose(()=>`Filling grants of ${Object.keys(this._activities).length} activities`);this.fillGrants(),e.success(),e=logger.verbose(()=>"Setting permissions"),this.flattenPermissions(),e.success()}}}exports.ActivityManager=ActivityManager;
//# sourceMappingURL=activity-manager.js.map