/** @packageDocumentation @module index */
import type * as TestFixtures from './test/fixtures';
export * from './lib/index';
export * from './lib/sql/sql-context';
export * from './lib/test/manager-mocks';
export declare function getTestFixtures(): typeof TestFixtures;
/**
 * Interface hook for context module augmentation
 * Other system packages can add their own API to the Context class by extending this interface
 * @sage/xtrem-communication uses this to add the `send` and `notify` methods.
 *
 * Note: this interface must be defined *here*. Do not move it to lib/runtime/context.ts because
 * external modules cannot reference modules like @sage/xtrem-core/lib/...
 */
export interface ContextAugmentation {
}
declare module './lib/runtime/context' {
    interface Context extends ContextAugmentation {
    }
}
//# sourceMappingURL=index.d.ts.map