"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.queryAggregateSelector = exports.queryOperationSelector = exports.fullSelector = void 0;
const json_to_graphql_query_1 = require("json-to-graphql-query");
function wrap(path, data, isMutation) {
    const p = [isMutation ? 'mutation' : 'query'].concat(path);
    return p.reduceRight((r, k) => ({ [k]: r }), data);
}
/** @internal */
function fullSelector(path, selector, isMutation, transform) {
    const replace = (val) => {
        if (typeof val !== 'object')
            return val;
        if (val == null)
            return val;
        if (Array.isArray(val))
            return val.map(replace);
        const child = Object.keys(val).reduce((r, k) => {
            if (k === '_by') {
                // special case for group by selector.
                // prop: { _by: 'month' } must be converted to prop(by: 'month')
                r.__args = { by: new json_to_graphql_query_1.EnumType(val[k]) };
            }
            else {
                r[k] = replace(val[k]);
            }
            return r;
        }, {});
        return transform ? transform(child) : child;
    };
    // replace using a wrapped clone of the original selector
    return replace(wrap(path, { ...selector }, isMutation));
}
exports.fullSelector = fullSelector;
/** @internal */
function queryOperationSelector(path, selector, isMutation) {
    return fullSelector(path, selector, isMutation, (child) => {
        // convert selector from { document { edges { } } } to { document { query { edges { } } } }
        if (child.edges && child.edges.node) {
            return { query: child };
        }
        return child;
    });
}
exports.queryOperationSelector = queryOperationSelector;
/** @internal */
function queryAggregateSelector(path, selector, isMutation) {
    return fullSelector(path, selector, isMutation, (child) => {
        // convert selector from { document { edges { } } } to { document { queryAggregate { edges { } } } }
        if (child.edges && child.edges.node) {
            return { queryAggregate: child };
        }
        return child;
    });
}
exports.queryAggregateSelector = queryAggregateSelector;
//# sourceMappingURL=selector.js.map