import { Config } from './config';
import { Request } from './request';
import { OnlySelected, Selector } from './selector';
export type Operation<ArgT, T> = <SelectorT extends Selector<T extends (infer U)[] ? U : T>>(selector: SelectorT, args: ArgT) => Request<OnlySelected<T, SelectorT>>;
/** Extract the type of the result of the operation */
export type OperationResultType<Op> = Op extends Operation<any, infer T> ? T : never;
/** Extract the type of the result of the operation */
export type OperationParamType<Op> = Op extends Operation<infer T, any> ? T : never;
export type ExtractArray<T> = T extends Array<infer U> ? U : T;
export type AsyncMutationStatus = 'pending' | 'running' | 'success' | 'error';
export interface PollingOptions {
    callback?(arg: {
        pollCount: number;
        elapsedMillis: number;
        status: AsyncMutationStatus;
    }): boolean;
}
export interface AsyncMutationResponse<T> {
    status: AsyncMutationStatus;
    result: T;
    errorMessage?: string;
}
export declare const runToCompletionOperation: <ArgT, T>(config: Config, path: string[]) => <SelectorT extends Selector<T>>(selector: SelectorT, args: ArgT, options?: PollingOptions) => {
    execute: () => Promise<OnlySelected<T, SelectorT>>;
};
//# sourceMappingURL=operations.d.ts.map