"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.nodeMutations = void 0;
const operations_1 = require("./operations");
/** @internal */
const nodeMutations = (config, path) => {
    return {
        // built-in mutations
        create: (0, operations_1.nodeOperation)(config, path, 'create', true),
        duplicate: (0, operations_1.nodeOperation)(config, path, 'duplicate', true),
        update: (0, operations_1.nodeOperation)(config, path, 'update', true),
        updateById: (0, operations_1.nodeIdOperation)(config, path, 'updateById', true),
        delete: (0, operations_1.scalarOperation)(config, path, 'delete', true),
        deleteById: (0, operations_1.scalarIdOperation)(config, path, 'deleteById', true),
        // custom mutations
        mutations: new Proxy({}, {
            get(_dummy, name) {
                if (typeof name !== 'string')
                    throw new Error(`${path.join('/')}: bad proxy request: ${typeof name}`);
                return (0, operations_1.nodeOperation)(config, path, name, true);
            },
        }),
        asyncOperations: new Proxy({}, {
            get(dummy, name) {
                if (typeof name !== 'string')
                    throw new Error(`${path.join('/')}: bad proxy request: ${typeof name}`);
                return {
                    runToCompletion: (0, operations_1.runToCompletionOperation)(config, [...path, name]),
                    start: (0, operations_1.nodeOperation)(config, [...path, name], 'start', true),
                    stop: (0, operations_1.nodeOperation)(config, [...path, name], 'stop', true),
                    track: (0, operations_1.nodeOperation)(config, [...path, name], 'track', false),
                };
            },
        }),
    };
};
exports.nodeMutations = nodeMutations;
//# sourceMappingURL=node-mutations.js.map