// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/index.d.ts
declare module '@sage/xtrem-cli-main/index' {
	export * from '@sage/xtrem-cli-main/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/lib/web-socket-hook.d.ts
declare module '@sage/xtrem-cli-main/lib/web-socket-hook' {
	/**
	 * Install the web socket hook into @sage/xtrem-service.
	 * This hook allows us to have a leaner packaging of X3 Services.
	 * It eliminates a direct dependency between @sage/xtrem-service and @sage/xtrem-infrastructure-adapter,
	 * which would bring a lot of heavy dependencies (@aws-sdk) into the service package.
	 */
	export function initializeWebSocketHook(): void;
	//# sourceMappingURL=web-socket-hook.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/lib/index.d.ts
declare module '@sage/xtrem-cli-main/lib/index' {
	import { Argv } from 'yargs';
	export { StartContext, StartOptions, startServices, StartServicesOptions } from '@sage/xtrem-cli-main/lib/commands/handlers/start/index';
	export const plugin: (yargs: Argv) => Argv;
	export const builder: {};
	export const handler: {};
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/lib/commands/start.d.ts
declare module '@sage/xtrem-cli-main/lib/commands/start' {
	import { Argv } from 'yargs';
	import { StartOptions } from '@sage/xtrem-cli-main/lib/commands/handlers/start/index';
	/**
	 * The command name and its aliases
	 */
	export const command: string[];
	/**
	 * The command description
	 */
	export const desc = "Start an xtrem application";
	/**
	 * The command builder that defines the syntax of this command
	 */
	export const builder: (yargs: Argv) => Argv<{}>;
	/**
	 * The command handler called to execute the actions of this command
	 */
	export const handler: (argv: Argv<StartOptions>) => Promise<void>;
	//# sourceMappingURL=start.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/lib/commands/handlers/start/worker.d.ts
declare module '@sage/xtrem-cli-main/lib/commands/handlers/start/worker' {
	/// <reference types="node" />
	/// <reference types="node" />
	import { Dict } from '@sage/xtrem-core';
	import { Cluster, Worker } from 'cluster';
	export class XtremWorker {
	    readonly initWorkerId: string;
	    readonly cluster: Cluster;
	    requestKeys: string[];
	    promise: Promise<void>;
	    /**
	     *
	     * @param workerId the identifier of the worker
	     * @param cluster the cluster instance used to manage(fork/spawn) a worker
	     */
	    constructor(initWorkerId: string, cluster: Cluster);
	    get workerId(): string;
	    set workerId(workerId: string);
	    init(): this;
	    /**
	     * reset the current worker instance with newly forked one.
	     */
	    fork(requestKey?: string): void;
	    /**
	     * The current Worker instance that is alive
	     */
	    get worker(): Worker;
	    /**
	     * The index of the worker in the cluster instance workers dictionary
	     */
	    get index(): number;
	    /**
	     * Is the worker ready to use, this set when the worker process sends a message back to the main process with the port
	     */
	    get isReady(): boolean;
	    /**
	     * Is the worker set and is the worker alive
	     */
	    get workerExists(): boolean;
	    /**
	     * Port of the current worker
	     */
	    get port(): number;
	    static workers: Dict<XtremWorker[]>;
	    static counters: Dict<number>;
	    /**
	     * Add a worker to the workers list
	     * @param cluster
	     * @param startIndex
	     * @param stopIndex
	     */
	    static addWorkers(cluster: Cluster, requestSource: string, startIndex: number, stopIndex: number): void;
	    /**
	     * Seed a worker for the request source, if the worker pool does not have enough workers
	     * @param cluster
	     * @param requestSource
	     * @param maxWorkers
	     */
	    static seedWorker(cluster: Cluster, requestSource: string, maxWorkers?: number): void;
	    static defaultSeedInterval: NodeJS.Timeout;
	    static deferredWorkerTimeout: Dict<NodeJS.Timeout>;
	    static seeded: boolean;
	    /**
	     * Spawn workers for the known sources as far as possible
	     * @param cluster
	     */
	    static seedWorkers(cluster: Cluster): void;
	    /**
	     * Fill the request source worker list with workers from the default worker list, only if the default source has workers available
	     * and the request source does not have enough workers
	     * @param requestSource
	     * @param maxWorkers
	     */
	    static fillFromDefaultWorkers(requestSource: string, maxWorkers: number): void;
	    /**
	     * Initialize the list of workers
	     * @param cluster
	     * @param maxWorkers
	     */
	    static initializeWorkers(cluster: Cluster, requestSource: string, maxWorkers: number): void;
	    /**
	     * sleep for the supplied number of ms
	     */
	    static sleep(ms: number): Promise<void>;
	    private static fillRequestSource;
	    /**
	     * Get the next worker that is ready from the workers list
	     * @param cluster
	     * @param requestSource
	     * @param count
	     * @returns
	     */
	    static getNextWorker(cluster: Cluster, requestSource: string, requestKey: string): Promise<XtremWorker | undefined>;
	}
	//# sourceMappingURL=worker.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/lib/commands/handlers/start/start-server.d.ts
declare module '@sage/xtrem-cli-main/lib/commands/handlers/start/start-server' {
	import { Application, StartChannel } from '@sage/xtrem-core';
	export interface StartServicesOptions {
	    channels: StartChannel[];
	    services?: string;
	    webSockets?: string[];
	    configExtensionLocation?: string;
	    /**
	     * Names of queues to explicitly start
	     * If not set, all the queues will be started
	     */
	    queues?: string[];
	}
	/**
	 * Start a service for the current process
	 * @param dir
	 * @param options
	 * @returns
	 */
	export const startWorkerServices: (application: Application) => Promise<void>;
	/**
	 * Manage the start command, if multi-worker service are enabled then start the proxy service, otherwise start a single process as normal
	 * @param dir
	 * @param options
	 * @returns
	 */
	export const startServices: (dir: string, options: StartServicesOptions) => Promise<void>;
	//# sourceMappingURL=start-server.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/lib/commands/handlers/start/start-cluster.d.ts
declare module '@sage/xtrem-cli-main/lib/commands/handlers/start/start-cluster' {
	import { StartServicesOptions } from '@sage/xtrem-cli-main/lib/commands/handlers/start/start-server';
	export const startCluster: (dir: string, options: StartServicesOptions) => Promise<void>;
	//# sourceMappingURL=start-cluster.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-main/build/lib/commands/handlers/start/index.d.ts
declare module '@sage/xtrem-cli-main/lib/commands/handlers/start/index' {
	import { StartChannel } from '@sage/xtrem-core';
	import { StartServicesOptions, startServices } from '@sage/xtrem-cli-main/lib/commands/handlers/start/start-server';
	export { StartServicesOptions, startServices };
	export interface StartOptions {
	    isUsingReferences?: boolean;
	    cluster?: boolean;
	    channels?: StartChannel[];
	    services?: string;
	    webSockets?: string;
	    configExtensionLocation?: string;
	    /**
	     * Names of queues to explicitly start
	     * If not set, all the queues will be started
	     */
	    queues?: string[];
	}
	export interface StartContext {
	    dir: string;
	    deployedApp: any;
	    options: StartOptions;
	    startServerOptions: StartServicesOptions;
	}
	export const scriptName = ".cli-start.js";
	export function createStartContext(options: StartOptions): StartContext;
	export const start: (startContext: StartContext) => Promise<void>;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/xtrem-cli-main' {
	export * from '@sage/xtrem-cli-main/index';
}
