/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.XtremWorker=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_service_1=require("@sage/xtrem-service"),util_1=require("util"),logger=new xtrem_core_1.Logger(__filename,"cli"),defaultSource="__default__";class XtremWorker{#e;#r;#t;#s;#i;#o;constructor(e,r){this.initWorkerId=e,this.cluster=r,this.#t=false,this.requestKeys=[],this.#o=e}get workerId(){return this.#o}set workerId(e){if(this.#o!==defaultSource)throw new Error("WorkerId cannot be changed");this.#o=e}init(){return this.fork(),this}fork(e){this.#t=false,this.#e=void 0,this.#r=this.cluster.fork({XTREM_WORKER_ID:this.workerId}),this.promise=new Promise((e,r)=>{this.#s=e,this.#i=r});const r=1e3*(0,xtrem_core_1.graphQlTimeLimitInSeconds)()-500,t=setTimeout(()=>{this.#i(new Error("Failed to start worker"))},r);if(logger.info(`Forked worker for ${this.workerId}(pid: ${this.#r.process.pid})`),this.#r.on("message",e=>{if("listening"===e.event&&e.workerId===this.initWorkerId)this.#e=e.port,this.#t=true,clearTimeout(t),this.#s()}),e&&!this.requestKeys.includes(e))this.requestKeys.push(e)}get worker(){if(this.workerExists)return this.#r;return this.fork(),this.#r}get index(){if(!this.worker)return-1;return this.worker.id}get isReady(){return this.#t}get workerExists(){return null!=this.#r&&!this.#r.isDead()}get port(){if(!this.#e)throw new Error(`[${this.worker}]: port not set.`);return this.#e}static{this.workers={}}static{this.counters={}}static addWorkers(e,r,t,s){if(!this.workers[r])this.workers[r]=[],this.counters[r]=0;for(let i=t;i<s;i+=1)this.workers[r].push(new XtremWorker(r,e).init())}static seedWorker(e,r,t=2){const s=this.workers[r]??[];if(s.length<t){const i=t-s.length;logger.info(`Seeding workers for ${r} with ${i} workers`),this.addWorkers(e,r,0,i)}}static{this.deferredWorkerTimeout={}}static{this.seeded=false}static seedWorkers(e){if(xtrem_service_1.GraphqlEndpointHooks.getSourcesToSeed().filter(e=>!this.workers[e]||0===this.workers[e].length).forEach(r=>{this.seedWorker(e,r,1)}),!this.workers[defaultSource]||0===this.workers[defaultSource].length)if(this.seedWorker(e,defaultSource,1),!this.defaultSeedInterval)this.defaultSeedInterval=setInterval(()=>{if(XtremWorker.workers[defaultSource].length<2)XtremWorker.seedWorker(e,defaultSource,2)},6e4);this.seeded=true}static fillFromDefaultWorkers(e,r){if(xtrem_service_1.GraphqlEndpointHooks.getSourcesToSeed().includes(e)||0===this.workers[defaultSource]?.length)return;if(this.workers[e]&&this.workers[e].length>=r)return;if(this.workers[defaultSource]?.length>0){const t=this.workers[defaultSource].splice(0,r);if(t.forEach(r=>{r.workerId=e}),!this.workers[e])this.workers[e]=[],this.counters[e]=0;this.workers[e].push(...t)}}static initializeWorkers(e,r,t){this.addWorkers(e,r,0,t)}static async sleep(e){await(0,util_1.promisify)(setTimeout)(e)}static async fillRequestSource(e,r){let t=0;for(;!this.seeded;)if(await this.sleep(100),t+=1,t>10)return false;const s=xtrem_core_1.ConfigManager.current.server?.worker?.workersPerRequestSource??2;if(this.fillFromDefaultWorkers(r,s),!this.workers[r]||0===this.workers[r].length)this.initializeWorkers(e,r,1);if(this.workers[r].length<s)if(!this.deferredWorkerTimeout[r]){const t=s-this.workers[r].length;this.deferredWorkerTimeout[r]=setTimeout(()=>{XtremWorker.initializeWorkers(e,r,t),delete XtremWorker.deferredWorkerTimeout[r]})}return true}static async getNextWorker(e,r,t){if(!await this.fillRequestSource(e,r))return;let s=this.workers[r].find(e=>e.requestKeys.includes(t));if(null==s)if(s=this.workers[r][this.counters[r]],this.counters[r]=(this.counters[r]+1)%this.workers[r].length,t&&!s.requestKeys.includes(t))s.requestKeys.push(t);if(!s.workerExists)s.fork(t);if(!s.isReady)return s.promise.then(()=>s).catch(e=>void logger.error(e));return Promise.resolve(s)}}exports.XtremWorker=XtremWorker;
//# sourceMappingURL=worker.js.map