/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.startServices=exports.startWorkerServices=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_service_1=require("@sage/xtrem-service"),http=require("http"),https=require("https"),worker_1=require("./worker"),logger=new xtrem_core_1.Logger(__filename,"cli"),startWorkerServices=async e=>{await e.packageManager.validatePackageVersions(),await xtrem_core_1.Context.subscribeToCacheNotifications(e),e.activityManager.resolvePermissions(),e.validateActivities(),await(0,xtrem_service_1.startApplication)(e)};exports.startWorkerServices=startWorkerServices;const startServices=async(e,r)=>{if(r.configExtensionLocation)logger.info(`Config extension provided, ${r.configExtensionLocation}`),xtrem_core_1.ConfigManager.load(e,"start",r.configExtensionLocation);const t=require("cluster"),o=xtrem_core_1.ConfigManager.current.deploymentMode;if(xtrem_core_1.allowedStartChannels.every(e=>r.channels.includes(e))&&"production"===o)logger.warn(`Starting the server with all channels active (${xtrem_core_1.allowedStartChannels}).`);const s={...r,services:r.services?r.services.split(","):[]},i=await xtrem_core_1.ApplicationManager.getApplication(e,{applicationType:"service",startOptions:s}),n="true"===process.env.XTREM_USE_MULTI_WORKER;if("1"===process.env.XTREM_CLUSTER_FORK&&n)throw new Error("Cluster mode cannot be used with multi-service workers.");if(t.isPrimary)if(n)return startProxyService(t);if(t.isWorker)if(n&&!process.env.XTREM_WORKER_ID)throw new Error(`Worker ID not supplied for worker ${process.pid}`);return(0,exports.startWorkerServices)(i)};exports.startServices=startServices;const httpProxy=require("http-proxy");function getFullUrl(e,r){return`${e.headers["x-forwarded-proto"]||r?.server?.ssl?"https":"http"}://${e.headers.host}${e.url}`}function startProxyService(e){const r=xtrem_core_1.ConfigManager.current;e.on("exit",(e,r,t)=>{if(t)logger.info(`worker ${e.process.pid} was killed by signal: ${t}`);else if(0!==r)logger.info(`worker ${e.process.pid} exited with error code: ${r}`);else logger.info(`worker ${e.process.pid} success!`)});const t=new httpProxy.createProxyServer;let o;t.on("error",(e,t,o)=>{const s=getFullUrl(t,r);logger.info(`Proxy error: ${e.stack} ${e.errno}, ${e.code}, ${e.address},${e.port})}`),o.setHeader("Refresh",`5;url=${s}`),o.writeHead(503,{"Content-Type":"text/plain"}),o.end("Service unavailable")});const proxyListener=async(o,s)=>{if(o.url&&/^\/ping$/.test(o.url))return s.writeHead(200,{"Content-Type":"text/plain"}),void s.end("Service available");const i=r.server?.ssl?"https":"http",n=xtrem_service_1.GraphqlEndpointHooks.getRequestSource(o),a=xtrem_service_1.GraphqlEndpointHooks.getRequestRoutingKey(o),c=await worker_1.XtremWorker.getNextWorker(e,n,a);if(!c){const e=getFullUrl(o,r);return logger.info(`Proxy error: Failed to find worker for request to ${n}`),s.setHeader("Refresh",`5;url=${e}`),s.writeHead(503,{"Content-Type":"text/plain"}),void s.end("Failed to find worker")}logger.info(`proxy request for ${n}`).success(`proxy request for ${n} forwarded to ${c.port}`),t.web(o,s,{target:`${i}://localhost:${c.port}`})};if(r?.server?.ssl)o=https.createServer(r.server.ssl,proxyListener),(0,xtrem_core_1.registerTlsChangeListener)(o,"server.ssl","HTTPS proxy");else o=http.createServer(proxyListener);o.on("upgrade",(e,r,o)=>{t.ws(e,r,o)});const s=r.server?.port||8240;o.listen(s);const i=r.server?.ssl?" over TLS ":"";return logger.info(`Proxy service is listening on port ${s}${i}`),worker_1.XtremWorker.seedWorkers(e),Promise.resolve(void 0)}
//# sourceMappingURL=start-server.js.map