// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/index.d.ts
declare module '@sage/xtrem-cli-lib/index' {
	export * from '@sage/xtrem-cli-lib/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/pluggable.d.ts
declare module '@sage/xtrem-cli-lib/lib/pluggable' {
	/// <reference types="node" />
	import { Argv } from 'yargs';
	export interface PluggableHandlerResult {
	    skipDefault?: boolean;
	}
	export interface CliPlugin {
	    name: string;
	    exports: any;
	}
	export class PluginRegistry {
	    get plugins(): CliPlugin[];
	    add(plugin: CliPlugin): void;
	}
	export const pluginRegistry: PluginRegistry;
	export function pluggableBuilder(command: string | string[], yargs: Argv): Argv;
	export function pluggableHandler(command: string | string[], args: any, commandContext?: any): Promise<PluggableHandlerResult>;
	export function commandDir(yargs: Argv, mod: NodeJS.Module, dir: string): Argv<{}>;
	//# sourceMappingURL=pluggable.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/index.d.ts
declare module '@sage/xtrem-cli-lib/lib/index' {
	export * from '@sage/xtrem-cli-lib/lib/cli-context';
	export * from '@sage/xtrem-cli-lib/lib/cli-hooks';
	export * from '@sage/xtrem-cli-lib/lib/pluggable';
	export * from '@sage/xtrem-cli-lib/lib/utils/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/cli-hooks.d.ts
declare module '@sage/xtrem-cli-lib/lib/cli-hooks' {
	import { Application, ContextOptions, Package, StartChannel, UpgradeMetricsType } from '@sage/xtrem-core';
	export interface CliBundleManager {
	    activate(application: Application, tenantId: string, bundleId: string, pack: Package): void;
	    deactivate(application: Application, tenantId: string, bundleId: string): void;
	}
	export type UpgradeMode = 
	/**
	 * The upgrade will only replay previously recorded SQL queries (will not run any upgrade actions)
	 * This mode will raise an error if some recording files are missing.
	 * For instance, we are on version 6.0.0 and we want to upgrade to 7.0.0.
	 * An error will be raised if no SQL file is available from 6.0.40 to 6.0.48
	 */
	'replayOnly'
	/**
	 * The upgrade will replay previously recorded SQL queries and then run the upgrade actions
	 * For instance, we are on version 6.0.0 and we want to upgrade to 7.0.0.
	 * We have recorded SQL queries for versions [6.0.0 to 6.0.49[
	 * The upgrade will:
	 * - replay the SQL queries for versions [6.0.0 to 6.0.49[
	 * - run the upgrade actions (and record them) for versions [6.0.49 to 7.0.0[
	 */
	 | 'replayAndUpgrade'
	/**
	 * Same as replayAndUpgrade except that the SQL will be recorded to a local file
	 */
	 | 'replayAndRecord'
	/**
	 * The upgrade will skip the playing of recorded SQL queries
	 */
	 | 'upgradeOnly';
	export interface UpgradeOptions {
	    /** Should the upgrade be executed even if the versions match (i.e. the package seems to be up-to-date) */
	    force: boolean;
	    /**
	     * Upgrade mode:  replayOnly / replayAndUpgrade / replayAndRecord / upgradeOnly
	     */
	    mode: UpgradeMode;
	    /**
	     * Should all the CSV files from the SETUP layer be reloaded at the end of the upgrade ?
	     * This will bypass the lookup from the git repo and reload all the **setup** CSV files
	     */
	    fullReloadOfSetupLayer: boolean;
	    /**
	     * Should metrics files be generated ?
	     * undefined : no CSV/JSON files, local:only on local, s3: local + S3
	     */
	    metrics?: UpgradeMetricsType;
	    /**
	     * Should we skip VACUUM at the end of the upgrade
	     */
	    skipVacuum?: boolean;
	    /**
	     * Check that the SQL schema is in sync with node definitions. Raise an error if not.
	     */
	    checkSchema?: boolean;
	}
	export interface CliUpgradeManager {
	    upgradeSqlSchemaFromCli(application: Application, options: UpgradeOptions): Promise<void>;
	    /**
	     * Rename the 'vlatest' folders of upgrades (upgrade suites, system upgrades)
	     */
	    renameLatestFolders(rootFolder: string): void;
	    fixColumnOrder(application: Application): Promise<void>;
	    /**
	     * Execute a custom SQL script
	     * @param path the path to the script to execute
	     * @param tenantIds the tenantIds on which the script has to be executed
	     * @param dryRun run in dry mode ? (no commit)
	     */
	    executeCustomSqlScript(application: Application, path: string, tenantIds: string[], dryRun: boolean): Promise<void>;
	}
	export interface CliDataPatchManager {
	    execute(application: Application): void;
	    postProcess(application: Application): void;
	}
	export interface StartApplicationOptions {
	    channels: StartChannel[];
	}
	export interface CliTestManager {
	    prepareLoadTestDatabase(application: Application, contextOptions: ContextOptions): Promise<void>;
	}
	export abstract class CliHooks {
	    static packageManager: CliBundleManager;
	    static upgradeManager: CliUpgradeManager;
	    static dataPatchManager: CliDataPatchManager;
	    static testManager: CliTestManager;
	}
	//# sourceMappingURL=cli-hooks.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/cli-context.d.ts
declare module '@sage/xtrem-cli-lib/lib/cli-context' {
	import { ExecutionMode } from '@sage/xtrem-cli-lib/lib/utils/index';
	export interface CliContext {
	    executionMode: ExecutionMode;
	    dir: string;
	    withExecutionMode: (executionMode: ExecutionMode, body: () => void) => void;
	}
	class CliContextConcret implements CliContext {
	    constructor(executionMode: ExecutionMode, dir: string);
	    get executionMode(): ExecutionMode;
	    get dir(): string;
	    withExecutionMode(executionMode: ExecutionMode, body: () => void): void;
	}
	export const cliContext: CliContextConcret;
	export {};
	//# sourceMappingURL=cli-context.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/utils/socket-helper.d.ts
declare module '@sage/xtrem-cli-lib/lib/utils/socket-helper' {
	import * as ts from 'typescript';
	export enum EventType {
	    AUTH = "AUTH",
	    REBOUNCE = "REBOUNCE",
	    FATAL_ERROR = "FATAL_ERROR",
	    COMPILER_STARTED = "COMPILER_STARTED",
	    COMPILER_SUCCESS = "COMPILER_SUCCESS",
	    COMPILER_FAILURE = "COMPILER_FAILURE"
	}
	export type ErrorSource = 'server' | 'client';
	export interface Event {
	    type: EventType;
	    data: any;
	}
	export interface CompilationError {
	    code: number;
	    file: string;
	    line: number;
	    character: number;
	    message: string;
	    source: ErrorSource;
	}
	export const initiateSocketServer: (key: string, options?: {
	    onRebounce: () => void;
	}) => Promise<void>;
	export const broadcastMessage: (type: EventType, data?: any) => void;
	export const addTsDiagnosticToDispatchQueue: (diagnostic: ts.Diagnostic, source: ErrorSource) => void;
	export const addTsLoaderErrorToDispatchQueue: (error: string, dir: string) => void;
	export const addCompilerErrorToDispatchQueue: (error: CompilationError) => void;
	export const broadcastCompilerSuccessMessage: (type: ErrorSource) => void;
	//# sourceMappingURL=socket-helper.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/utils/logger.d.ts
declare module '@sage/xtrem-cli-lib/lib/utils/logger' {
	import { Logger } from '@sage/xtrem-core';
	import { ExecutionMode } from '@sage/xtrem-cli-lib/lib/utils/common';
	/**
	 * Subclass of standard xtrem-log logger, to get the fancy cli formatting.
	 */
	export class CliLogger extends Logger {
	    readonly executionMode: ExecutionMode;
	    readonly options?: {
	        warningsAsErrors?: boolean | undefined;
	    } | undefined;
	    constructor(executionMode: ExecutionMode, options?: {
	        warningsAsErrors?: boolean | undefined;
	    } | undefined);
	    profilerCallback: {
	        success: (message: string) => void;
	        fail: (message: string) => void;
	    };
	    error(message: string): this['profilerCallback'];
	    warn(message: string): this['profilerCallback'];
	    info(message: string): this['profilerCallback'];
	}
	//# sourceMappingURL=logger.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/utils/index.d.ts
declare module '@sage/xtrem-cli-lib/lib/utils/index' {
	export * from '@sage/xtrem-cli-lib/lib/utils/application';
	export * from '@sage/xtrem-cli-lib/lib/utils/common';
	export * from '@sage/xtrem-cli-lib/lib/utils/file';
	export * from '@sage/xtrem-cli-lib/lib/utils/logger';
	export * from '@sage/xtrem-cli-lib/lib/utils/socket-helper';
	//# sourceMappingURL=index.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/utils/file.d.ts
declare module '@sage/xtrem-cli-lib/lib/utils/file' {
	/// <reference types="node" />
	import * as fs from 'fs';
	export enum PackagingMode {
	    DEV = "DEV",
	    PROD = "PROD"
	}
	export enum ArtifactTypes {
	    Pages = "pages",
	    Stickers = "stickers",
	    PageExtensions = "page-extensions",
	    PageFragments = "page-fragments"
	}
	export const getNpmCommandName: () => "npm.cmd" | "npm";
	export function mkdirp(p: string): void;
	export function safeRmSync(fileOrDir: string, options?: fs.RmOptions): void;
	export function copyFile(source: string, target: string): void;
	export function copyFolderRecursive(source: string, target: string, noPreserve?: boolean): void;
	export function getMetadataFilePathForClientFile(dir: string, filePath: string): string;
	export function hashFile(filePath: string): string;
	//# sourceMappingURL=file.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/utils/common.d.ts
declare module '@sage/xtrem-cli-lib/lib/utils/common' {
	import { AnyValue, AsyncResponse } from '@sage/xtrem-core';
	export enum ExecutionMode {
	    STANDALONE = "STANDALONE",
	    INTEGRATED = "INTEGRATED"
	}
	export const plural: (a: string, b: string, count: number) => string;
	/**
	 * Raise an error when the command line could not be processed
	 */
	export function raiseErrorOnInvalidCommandLine(): never;
	export const quitWithError: (mode: ExecutionMode, error: string | Error) => never;
	export const printSuccess: (mode: ExecutionMode, message: string, logDuration?: boolean) => void;
	export const printInfo: (mode: ExecutionMode, message: string) => void;
	export const printWarning: (mode: ExecutionMode, message: string) => void;
	export const printError: (mode: ExecutionMode, message: string) => void;
	export const withTiming: <T extends void | AnyValue>(mode: ExecutionMode, options: {
	    before?: () => string;
	    body: () => AsyncResponse<T>;
	    success?: (result: T) => string;
	    fail?: (err: Error) => string;
	}) => Promise<T>;
	export const isDebugging: boolean;
	//# sourceMappingURL=common.d.ts.map
}
// From file: /agent/_work/1/s/platform/cli/xtrem-cli-lib/build/lib/utils/application.d.ts
declare module '@sage/xtrem-cli-lib/lib/utils/application' {
	export function activatesContainerHeartbeatMonitor(): void;
	//# sourceMappingURL=application.d.ts.map
}
declare module '@sage/xtrem-cli-lib' {
	export * from '@sage/xtrem-cli-lib/index';
}
