import { Logger } from '@sage/xtrem-core';
import { ExecutionMode } from './common';
/**
 * Subclass of standard xtrem-log logger, to get the fancy cli formatting.
 */
export declare class CliLogger extends Logger {
    readonly executionMode: ExecutionMode;
    readonly options?: {
        warningsAsErrors?: boolean | undefined;
    } | undefined;
    constructor(executionMode: ExecutionMode, options?: {
        warningsAsErrors?: boolean | undefined;
    } | undefined);
    profilerCallback: {
        success: (message: string) => void;
        fail: (message: string) => void;
    };
    error(message: string): this['profilerCallback'];
    warn(message: string): this['profilerCallback'];
    info(message: string): this['profilerCallback'];
}
//# sourceMappingURL=logger.d.ts.map