/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.isDebugging=exports.withTiming=exports.printError=exports.printWarning=exports.printInfo=exports.printSuccess=exports.quitWithError=exports.raiseErrorOnInvalidCommandLine=exports.plural=exports.ExecutionMode=void 0;const xtrem_core_1=require("@sage/xtrem-core"),chalk_1=require("chalk"),socket_helper_1=require("./socket-helper"),logger=new xtrem_core_1.Logger(__filename,"cli");var ExecutionMode;!function(e){e.STANDALONE="STANDALONE",e.INTEGRATED="INTEGRATED"}(ExecutionMode||(exports.ExecutionMode=ExecutionMode={}));const plural=(e,r,o)=>`${o} ${1===o?e:r}`;function isErrorObject(e){return e instanceof Error}function raiseErrorOnInvalidCommandLine(){throw new Error(`Could not parse command line: ${[...process.argv].splice(1).join(" ")}`)}exports.plural=plural,exports.raiseErrorOnInvalidCommandLine=raiseErrorOnInvalidCommandLine;const quitWithError=(e,r)=>{const o=isErrorObject(r)?r.message:r;if(e===ExecutionMode.STANDALONE){if(isErrorObject(r))console.log(r.stack);console.log(chalk_1.default.red(`   🚨🌋 ${o}   `)),(0,socket_helper_1.broadcastMessage)(socket_helper_1.EventType.FATAL_ERROR,o),process.exit(1)}else throw logger.error(o),new Error(o)};exports.quitWithError=quitWithError;let _inProcess=false,_processStartTime=Date.now();const printSuccess=(e,r,o=true)=>{if(e===ExecutionMode.STANDALONE){if(o)console.log(chalk_1.default.green(`   ✅    ${r} (${Date.now()-_processStartTime} ms)  `));else console.log(chalk_1.default.green(`   ✅    ${r}`));_inProcess=false}else console.log(chalk_1.default.green(`   ✅    ${r}`))};exports.printSuccess=printSuccess;const printInfo=(e,r)=>{if(e===ExecutionMode.STANDALONE){if(console.log(chalk_1.default.blue(`   📢    ${r}   `)),!_inProcess)_inProcess=true,_processStartTime=Date.now()}else logger.info(r)};exports.printInfo=printInfo;const printWarning=(e,r)=>{if(e===ExecutionMode.STANDALONE)console.log(chalk_1.default.yellow(`   ⚠️    ${r}   `));else logger.warn(r)};exports.printWarning=printWarning;const printError=(e,r)=>{if(e===ExecutionMode.STANDALONE)console.log(chalk_1.default.red(`   ❌    ${r} (${Date.now()-_processStartTime} ms)  `)),_inProcess=false;else logger.error(r)};exports.printError=printError;const withTiming=async(e,r)=>{const o=Date.now();if(r.before)(0,exports.printInfo)(e,r.before());try{const t=await r.body(),n=Date.now()-o;let s=chalk_1.default.red;if(n<1e3)s=chalk_1.default.gray;else if(n<5e3)s=chalk_1.default.yellow;const i=s(`(${n} ms)`);if(r.success)(0,exports.printInfo)(e,`${r.success(t)} ${i}`);return t}catch(o){if(r.fail)(0,exports.printError)(e,r.fail(o));throw o}};exports.withTiming=withTiming,exports.isDebugging="object"==typeof global||/--debug|--inspect|--inspect-brk/.test(process.execArgv.join(" "));
//# sourceMappingURL=common.js.map