/// <reference types="node" />
/// <reference types="node" />
interface BaseCompileOptions {
    output?: string;
    compileAsModule?: boolean;
    getPreservedRanges?: (source: string) => [number, number][];
    compress?: boolean;
    minify?: boolean;
    verbose?: boolean;
    deleteSource?: boolean;
}
export interface CompileFileArguments extends BaseCompileOptions {
    filename: string;
}
export interface CompileOptions extends BaseCompileOptions {
    replacementSource?: Buffer;
    module?: boolean;
}
export interface CompileCodeOptions extends CompileOptions {
    filename: string;
}
export interface SystemInfo {
    nodeVersion: string;
    arch: string;
}
export interface Content {
    systemInfo: Uint8Array;
    dummyCode: Uint8Array;
    bytecodeBuffer: Uint8Array;
}
export declare function shouldMinify(packageJson: any): boolean;
/**
 * install source-map-support with value for retrieveSourceMap function that will be used to retrieve the source map file content
 * @param options
 */
export declare function sourceMapSetup(options?: any): void;
export declare function getSystemInfo(): SystemInfo;
/**
 * Generates v8 bytecode buffer.
 * @param   {string} javascriptCode JavaScript source that will be compiled to bytecode.
 * @returns {Buffer} The generated bytecode.
 */
export declare function compileCode(javascriptCode: string, options?: CompileCodeOptions): Buffer;
export declare function compileAllFiles(packageDir: string, files: string[], options: CompileOptions): Promise<void>;
/**
 * Compiles JavaScript file to .jsb/.jsbz file.
 * @param   options
 * @returns The compiled filename
 */
export declare function compileFile(options: CompileCodeOptions): Promise<string>;
/**
 * Runs v8 bytecode buffer and returns the result.
 * @param   {Buffer} bytecodeBuffer The buffer object that was created using compileCode function.
 * @returns {any}    The result of the very last statement executed in the script.
 */
export declare function runBytecode(bytecodeBuffer: Buffer, filename: string): any;
/**
 * Runs .jsb/.jsbz file and returns the result.
 * @param   {string} filename
 * @returns {any}    The result of the very last statement executed in the script.
 */
export declare function runBytecodeFile(filename: string): any;
export declare function reexportAll(mainIndex: string): void;
export {};
//# sourceMappingURL=bytenode.d.ts.map