/**
 * This class can be used in async loops to keep the event loop healthy
 *
 * @example
 *  const healthyEventLoop = new HealthyEventLoop(10000)
 *
 *  then, in loops
 *      if (healthyEventLoop.shouldYield) {
 *          await healthyEventLoop.yield();
 *      }
 */
export declare class HealthyEventLoop {
    #private;
    private readonly yieldModulo;
    constructor(yieldModulo?: number);
    getYieldCount(): number;
    /**
     * Should the yield() function be called ?
     */
    get shouldYield(): boolean;
    /**
     * Yield with setImmediate to keep event loop healthy during any array iterations
     */
    yield(): Promise<void>;
}
//# sourceMappingURL=healthy-event-loop.d.ts.map