"use strict";
/// This module implements the xtrem-tsc compiler which is used to compile the low level platform packages:
/// xtrem-postgres, xtrem-core, ...
/// The higher level packages (xtrem-system, xtrem-authorization, xtrem-master-data, ...) are transformed
/// by xtrem-cli.
///
/// This code was borrowed almost verbatim from xtrem-cli/lib/command/compile/compile-server.ts
/// Code duplication is not an issue because this is throw away code.
/// It will go away once all the packages have been converted to async/await.
Object.defineProperty(exports, "__esModule", { value: true });
exports.compileServer = exports.getFiles = exports.getTsProgram = void 0;
const fs = require("fs");
const path = require("path");
const ts = require("typescript");
const server_compilation_1 = require("./server-compilation");
function getAccessibleFileSystemEntries(p) {
    try {
        const entries = fs.readdirSync(p || '.').sort();
        const files = [];
        const directories = [];
        entries.forEach(entry => {
            // This is necessary because on some file system node fails to exclude
            // "." and "..". See https://github.com/nodejs/node/issues/4002
            if (entry === '.' || entry === '..') {
                return;
            }
            const name = ts.combinePaths(p, entry);
            let stat;
            try {
                stat = fs.statSync(name);
            }
            catch (e) {
                return;
            }
            if (stat.isFile()) {
                files.push(entry);
            }
            else if (stat.isDirectory()) {
                directories.push(entry);
            }
        });
        return { files, directories };
    }
    catch (e) {
        return { files: [], directories: [] };
    }
}
const getTsProgram = (dir, options) => {
    const files = (0, exports.getFiles)(dir, options);
    return ts.createProgram(files, (0, server_compilation_1.getCompilerOptions)(dir, options?.configFileName || 'tsconfig.json', options?.tsconfigOverride));
};
exports.getTsProgram = getTsProgram;
const getFiles = (dir, options) => {
    const tsconfigPath = path.resolve(dir, options?.configFileName || 'tsconfig.json');
    const { include: includes, exclude: excludes, extends: extensions, } = JSON.parse(fs.readFileSync(tsconfigPath, 'utf-8'));
    /*
    See https://github.com/microsoft/TypeScript/blob/23f1d5ccb7202a1eac0a853abfdaf060b145a4b6/src/compiler/utilities.ts#L8085
    The "matchFiles" function has the following signature:
    (path: string, extensions: ReadonlyArray<string> | undefined, excludes: ReadonlyArray<string> | undefined, includes: ReadonlyArray<string> | undefined, useCaseSensitiveFileNames: boolean, currentDirectory: string, depth: number | undefined, getFileSystemEntries: (path: string) => FileSystemEntries, realpath: (path: string) => string): string[]
    and is useful in order to get the list of files to be compiled from the "include" and "exclude" properties.
    We need a complete list of files in order to support the "composite" feature and compile project references.
    */
    return ts.matchFiles(dir, extensions, options?.excludeOverride || excludes, options?.includeOverride || includes.filter((i) => !i.endsWith('.json')), true, process.cwd(), undefined, getAccessibleFileSystemEntries, ts.sys.realpath);
};
exports.getFiles = getFiles;
const compileServer = () => {
    const dir = process.cwd();
    const program = (0, exports.getTsProgram)(dir);
    const emitResult = program.emit(undefined, undefined, undefined, undefined, {});
    const allDiagnostics = ts.getPreEmitDiagnostics(program).concat(emitResult.diagnostics);
    allDiagnostics.forEach(server_compilation_1.printCompilerError);
    if (allDiagnostics.length === 0) {
        console.info('Typescript compilation OK');
    }
    else {
        console.error('Typescript compilation FAILED');
        process.exit(1);
    }
};
exports.compileServer = compileServer;
//# sourceMappingURL=compile-server.js.map