/* Copyright (c) 2020-2025 Sage. All Rights Reserved. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.MetadataStorageManager=void 0;const xtrem_decimal_1=require("@sage/xtrem-decimal"),typesLib=xtrem_decimal_1,xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),metadata_helper_1=require("./metadata-helper");var StorageStatus;!function(e){e[e.notStarted=0]="notStarted",e[e.done=1]="done",e[e.reload=2]="reload"}(StorageStatus||(StorageStatus={}));class MetadataStorageManager{constructor(){this.logger=xtrem_core_1.Logger.getLogger(__filename,"x3-metadata"),this._lastTransientId=-1e9}notAllowedError(e){return new Error(`${this.factory.name}:${e} is not allowed`)}get naturalKey(){if(!this.factory.naturalKey)throw new Error(`${this.factory.name}: natural key is not defined`);return this.factory.naturalKey}insert(e,t){throw this.notAllowedError("insert")}update(e,t){throw this.notAllowedError("update")}delete(e,t){throw this.notAllowedError("delete")}static getRecordValue(e,t){return metadata_helper_1.MetadataHelper.dataByNode[e.name].find(e=>typesLib.strictEq(e._id,t))}static getPropertyValue(e,t,r){let a=r?.[t.name];if(t.isReferenceProperty()&&typesLib.strictEq(typeof a,"string"))return MetadataStorageManager.getRecordValue(t.targetFactory,a);if(t.isReferenceArrayProperty()||t.isCollectionProperty())if(Array.isArray(a))return a.map(e=>MetadataStorageManager.getRecordValue(t.targetFactory,e));if(t.isEnumProperty()&&typesLib.strictEq(typeof a,"string"))a=t.dataType.numberValue(a);if(t.isStringProperty()&&t.isLocalized&&a&&typesLib.strictEq(typeof a,"object"))a=a[e.currentLocale];return a}query(e,t){let r=0;const a=this.factory.name,s=e.application.getFactoryByName(a);let i;const getPagedResult=async()=>{let r;if(await MetadataStorageManager.ensureItemsCached(e),t.collection&&typesLib.strictEq(t.collection.sourceNode.$.factory.name,"MetaNodeFactory"))r=await t.collection.sourceNode.$.get("name");const i=(metadata_helper_1.MetadataHelper.dataByNode[a]??[]).filter(e=>{if(!("factory"in e)||typesLib.strictEq(r,void 0))return true;return typesLib.strictEq(e.factory,r)});return xtrem_core_1.RecordPaging.applyPagingOptions(s,e,await(0,xtrem_core_1.asyncArray)(i).map(async t=>{Object.keys(t).forEach(r=>{const a=s.properties.find(e=>typesLib.strictEq(e.name,r));if(a&&a.isStringProperty()&&a.isLocalized&&typesLib.strictEq(typeof t[r],"object"))t[r]=t[r][e.currentLocale]});const r=await metadata_helper_1.MetadataHelper.getIsActiveValue(e,s,t);if(typesLib.ne(r,null))t.isActive=r;return t}).toArray(),MetadataStorageManager.getPropertyValue,t)};if(t.count)return new xtrem_core_1.AsyncArrayReader(async()=>[(await getPagedResult()).totalCount??0]);const read=async()=>{if(!i)i=(await getPagedResult()).items;if(typesLib.gt(r,typesLib.sub(i.length,1)))return;if(typesLib.strictEq(r,0))this.logger.verbose(()=>"query result ready");const e=i[r];if(typesLib.strictNe(e,void 0))r=typesLib.add(r,1);return e},stop=()=>{e.logger.verbose(()=>`${r} records read`)};return new xtrem_core_1.AsyncGenericReader({read,stop})}mapRecordIn(e){return e}mapAggregateRecordIn(e){throw new Error("NYI: metadata aggregate")}getReferenceJoin(e){return{_id:e}}getCollectionJoin(e){if(typesLib.strictEq(this.factory.name,"MetaNodeFactory")&&["properties","operations"].includes(e))return{factory:"name"};return{}}getJoinValues(e,t,r){if(typesLib.strictEq(r,"definingPackage")||typesLib.strictEq(r,"package")||typesLib.strictEq(r,"factory")||typesLib.strictEq(r,"extends")||typesLib.strictEq(r,"targetFactory")||typesLib.strictEq(r,"dataType"))return{name:t[r]};if(typesLib.strictEq(r,"reverseReference"))return{name:t[r],factory:t.targetFactory};if(typesLib.strictEq(r,"properties")||typesLib.strictEq(r,"operations"))return{factory:t.name};return{}}getPropertyFromPath(e){let t,r=this.factory;if(e.forEach((a,s)=>{const i=r.properties.find(e=>typesLib.strictEq(e.name,a));if(!i||typesLib.strictNe(s,typesLib.sub(e.length,1))&&!i.isReferenceProperty())throw new Error(`Invalid path: ${e.join(".")}`);if(t=i,typesLib.strictEq(s,typesLib.sub(e.length,1)))return;if(!i.isReferenceProperty())throw new Error(`Invalid path: ${e.join(".")}`);r=i.targetFactory}),!t)throw new Error(`Invalid path: ${e.join(".")}`);return t}convertOrderBy(e){const t=[],convertOne=(e,r)=>{Object.keys(r).forEach(a=>{const s=[...e,a],i=r[a];if(i&&typesLib.strictEq(typeof i,"object"))convertOne(s,i);else if(typesLib.strictEq(i,-1)||typesLib.strictEq(i,1)){const e=this.getPropertyFromPath(s);t.push({property:e,path:s,direction:i,sql:"",columnAlias:""})}else throw new Error(`${s}: invalid value: ${i})`)})};return convertOne([],e||{}),t}parseOrderBy(e,t){return this.convertOrderBy(t)}static safeParseInt(e,t){const r=Number(t);if(!Number.isInteger(r))throw new Error(`column ${e.name}: invalid integer value ${t}`);return r}static safeParseFloat(e,t){const r=Number(t);if(!Number.isFinite(r))throw new Error(`column ${e.name}: invalid number value ${t}`);return r}static parsePropertyValue(e,t){const{type:r}=e;if(typesLib.strictEq(r,"string")||typesLib.strictEq(r,"reference")||typesLib.strictEq(r,"enum"))return t;if(!t)return null;switch(r){case"float":case"double":case"decimal":return this.safeParseFloat(e,t);case"integer":case"short":return this.safeParseInt(e,t);case"boolean":return typesLib.strictEq(String(t),"true");case"date":return xtrem_core_1.DateValue.parse(t);case"dateRange":return xtrem_date_time_1.DateRange.parse(t);case"datetimeRange":return xtrem_date_time_1.DatetimeRange.parse(t);case"time":return xtrem_date_time_1.Time.parse(t);case"datetime":return xtrem_date_time_1.Datetime.parse(t);case"uuid":return xtrem_core_1.Uuid.fromString(t);default:throw new Error(`column ${e.name}: unsupported type ${r}`)}}static fastHash(e){let t=5381,r=e.length;for(;r;)r=typesLib.sub(r,1),t=typesLib.mul(t,33)^e.charCodeAt(r);return t>>>0}static cursorChecksum(e){const t=e.replace(/'/g,'"');return`#${(this.fastHash(t.replace(/'/g,'"'))%100).toString().padStart(2,"0")}`}static removeCursorChecksum(e){if(!e)return e;const t=e.substring(0,typesLib.sub(e.length,3)),r=this.cursorChecksum(t);if(!e.endsWith(r))throw new Error(`${e}: invalid cursor value (checksum verification failed)`);return t}static parseCursorValues(e,t){if(typesLib.strictEq(e.length,0))throw new Error("Cannot parse cursor: missing orderBy");if(typesLib.gt(t.length,e.length))throw new Error("Cannot parse cursor: too many values");if(typesLib.lt(t.length,e.length))throw new Error("Cannot parse cursor: too few values");return e.map((e,r)=>({property:e.property,value:this.parsePropertyValue(e.property,t[r])}))}parseCursor(e,t){const r=MetadataStorageManager.removeCursorChecksum(t);return MetadataStorageManager.parseCursorValues(e,(0,xtrem_core_1.friendlyJsonParse)(r))}allocateTransientId(){return this._lastTransientId=typesLib.sub(this._lastTransientId,1),String(this._lastTransientId)}getTransientValue(e,t){const r=this.factory.properties.find(e=>typesLib.strictEq(e.name,t)),a=r?.type||"unknown";switch(a){case"string":case"reference":return String(e.allocateTransientId());case"float":case"double":case"integer":case"short":case"decimal":return e.allocateTransientId();default:throw new Error(`Transient value for ${a} is not supported`)}}getKeyValues(e,t,r){if((0,xtrem_core_1.isScalar)(t)){if(typesLib.gt(this.naturalKey.length,1))throw new Error(`${this.factory.name} incomplete key passed for read.`);return{[this.naturalKey[0]]:t}}return this.factory.keyProperties.reduce((a,s)=>{if(a[s.name]=t[s.name],r?.allocateTransient&&typesLib.strictEq(a[s.name],void 0))a[s.name]=this.getTransientValue(e,s.name);return a},{})}isKeyPropertyTransient(e,t){return false}isReverseReferenceProperty(e){return false}get defaultOrderBy(){return this.naturalKey.reduce((e,t)=>(e[t]=1,e),{})}getId(e,t){return this.naturalKey.reduce((e,r,a)=>{const s=String(t[r]);if(typesLib.strictEq(this.factory.keyProperties.length,1)||typesLib.strictEq(a,0))return s;return`${e}|${s}`},"")}canCreate(e){return false}canUpdate(e){return false}canDelete(e){return false}canDeleteMany(e){return false}static{this.ensureItemsCachedFunnel=(0,xtrem_core_1.funnel)(1)}static{this.progress=StorageStatus.notStarted}static invalidateCache(){this.progress=StorageStatus.reload}static async ensureItemsCached(e){if(typesLib.strictEq(this.progress,StorageStatus.done))return;await this.ensureItemsCachedFunnel(async()=>{if(typesLib.strictNe(this.progress,StorageStatus.done))await metadata_helper_1.MetadataHelper.loadMetadataStorage(e),this.progress=StorageStatus.done})}}exports.MetadataStorageManager=MetadataStorageManager;
//# sourceMappingURL=metadata-storage-manager.js.map