import { DateValue } from '@sage/xtrem-date-time';

export enum ElementTypeEnum {
    string = 'string',
    number = 'number',
    date = 'date',
}

export type ElementType = keyof typeof ElementTypeEnum;

export enum DataTitle {
    // Applicable Amount Payable
    amount = 'AMOUNT',
    price = 'PRICE',
    // Production Date (YYMMDD)
    prodDate = 'PROD DATE',
    // Batch or Lot Number
    batchLot = 'BATCH/LOT',
    // Due Date (YYMMDD)
    dueDate = 'DUE DATE',
    // Packaging Date (YYMMDD)
    packDate = 'PACK DATE',
    // Best Before Date (YYMMDD)
    bestBefore = 'BEST BEFORE or BEST BY',
    // Expiration Date (YYMMDD)
    expiryDate = 'USE BY OR EXPIRY',
    // Sell By Date (YYMMDD)
    sellBy = 'SELL BY',
    // SSCC (Serial Shipping Container Code)
    sscc = 'SSCC',
    // Global Trade Item Number (GTIN)
    gtin = 'GTIN',
    // Global Identification Number for Consignment (GINC)
    ginc = 'GINC',
    // Global Shipment Identification Number (GSIN)
    gsin = 'GSIN',
    // GTIN of Contained Trade Items
    content = 'CONTENT',
    // Variant Number
    variant = 'VARIANT',
    // Serial Number
    serial = 'SERIAL',
    // Consumer product variant
    cpv = 'CPV',
    // Additional Item Identification
    additionalId = 'ADDITIONAL ID',
    // Customer Part Number
    customPartNumber = 'CUST. PART NO.',
    // Made-to-Order Variation Number
    mtoVariant = 'MTO VARIAN',
    // Made-to-Order Variation Number
    pcn = 'PCN',
    // Count of Items (Variable Measure Trade Item)
    varCount = 'VAR. COUNT',
    // Customer's Purchase Order Number
    orderNumber = 'ORDER NUMBER',
    // Routing code
    route = 'ROUTE',
    // Ship to - Deliver to Global Location Number
    shipToLoc = 'SHIP TO LOC',
    // Bill to - Invoice to Global Location Number
    billTo = 'BILL TO',
    // Purchased from Global Location Number
    purchaseFrom = 'PURCHASE FROM',
    // Ship for - Deliver for - Forward to Global Location Number
    shipForLoc = 'SHIP FOR LOC',
    // Ship to - Deliver to Postal Code Within a Single Postal Authority
    shipToPost = 'SHIP TO POST',
    // Country of Origin of a Trade Item
    origin = 'ORIGIN',
    // Country of Initial Processing
    // Up to 5 3-digit ISO-countrycodes
    countryInitialProcess = 'COUNTRY - INITIAL PROCESS.',
    // Country of Processing
    countryProcess = 'COUNTRY - PROCESS.',
    // Country of disassembly
    countryDisassembly = 'COUNTRY - DISASSEMBLY',
    // Country Covering full Process Chain
    countryFullProcess = 'COUNTRY - FULL PROCESS',
    // Country subdivision of origin
    countrySubdivision = 'ORIGIN SUBDIVISION',
    // NATO Stock Number (NSN)
    nsn = 'NSN',
    // UN/ECE Meat Carcasses and Cuts Classification
    meatCut = 'MEAT CUT',
    // Expiration Date and Time
    expiryTime = 'EXPIRY TIME',
    // Active Potency
    activePotency = 'ACTIVE POTENCY',
    // Net weight (Variable Measure Trade Item)
    netWeight = 'NET WEIGHT',
    // Net weight (Variable Measure Trade Item)
    grossWeight = 'GROSS WEIGHT',
    // Length or first dimension (Variable Measure Trade Item)
    length = 'LENGTH',
    // Width, diameter, or second dimension (Variable Measure Trade Item)
    width = 'WIDTH',
    // Depth, thickness, height, or third dimension (Variable Measure Trade Item)
    height = 'HEIGHT',
    // Area (Variable Measure Trade Item)
    area = 'AREA',
    netVolume = 'NET VOLUME',
    volume = 'VOLUME',
    kgPerSquareMeter = 'KG PER SQUARE METER',
}

export enum UnitOfMeasure {
    EACH = 'EACH',
    MILLIMETER = 'MILLIMETER',
    CENTIMETER = 'CENTIMETER',
    METER = 'METER',
    KILOMETER = 'KILOMETER',
    INCH = 'INCH',
    FOOT = 'FOOT',
    YARD = 'YARD',
    MILE = 'MILE',
    MILLILITER = 'MILLILITER',
    LITER = 'LITER',
    CUBIC_METER = 'CUBIC_METER',
    FLUID_OUNCE = 'FLUID_OUNCE',
    CUP = 'CUP',
    PINT = 'PINT',
    QUART = 'QUART',
    GALLON = 'GALLON',
    CUBIC_INCH = 'CUBIC_INCH',
    CUBIC_FOOT = 'CUBIC_FOOT',
    CUBIC_YARD = 'CUBIC_YARD',
    GRAM = 'GRAM',
    KILOGRAM = 'KILOGRAM',
    METRIC_TON = 'METRIC_TON',
    OUNCE = 'OUNCE',
    POUND = 'POUND',
    STONE = 'STONE',
    HUNDREDWEIGHT = 'HUNDREDWEIGHT',
    SHORT_TON = 'SHORT_TON',
    SECOND = 'SECOND',
    MINUTE = 'MINUTE',
    HOUR = 'HOUR',
    DAY = 'DAY',
    SQUARE_MILLIMETER = 'SQUARE_MILLIMETER',
    SQUARE_CENTIMETER = 'SQUARE_CENTIMETER',
    SQUARE_METER = 'SQUARE_METER',
    SQUARE_INCH = 'SQUARE_INCH',
    SQUARE_FOOT = 'SQUARE_FOOT',
    SQUARE_YARD = 'SQUARE_YARD',
    TROY_OUNCES = 'TROY_OUNCES',
    // Kilograms per square metre, yes, the ISO code for this _is_ "28".
    _28 = '28',
}

export type DataTypeSupported = string | DateValue | number;
export type UnitTypeSupported = string | undefined;

export class ParsedElement {
    private _data: DataTypeSupported;

    private _unit: UnitTypeSupported;

    constructor(
        public readonly ai: string,
        public readonly elementDataTitle: DataTitle,
        public readonly elementType: ElementType,
    ) {
        /* defines the object which represents a single element
         */
        switch (elementType) {
            case ElementTypeEnum.string:
                this._data = '';
                break;
            case ElementTypeEnum.number:
                this._data = 0;
                break;
            case ElementTypeEnum.date:
                this._data = '';
                break;
            default:
                this._data = '';
                break;
        }
        this.unit = undefined; // some elements are accompanied by an unit of
    }

    set unit(unit: UnitTypeSupported) {
        this._unit = unit;
    }

    get unit(): UnitTypeSupported {
        return this._unit;
    }

    set data(data: DataTypeSupported) {
        this._data = data;
    }

    get data(): DataTypeSupported {
        return this._data;
    }
}
