import { Destination, User } from '@sage/x3-system-api';

export async function getDestinations(user: User | null): Promise<Destination[] | null> {
    const defaultDestinations: Destination[] = [];
    if (user) {
        await user.userDestinations.query.edges.forEach(async item => {
            const userDestination = await item.node.destination;
            if (userDestination) {
                defaultDestinations.push(userDestination);
            }
        });
    }
    return defaultDestinations;
}
