"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyracusMethod = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
const sageXtremX3SystemUtils = require("@sage/xtrem-x3-system-utils");
const sageX3System = require("..");
const joins = {
    referenceJoins: {
        menuProfile: {
            profile() {
                return 0;
            },
            module: 'menuProfile',
        },
        functionProfile: {
            profile: 'functionProfile',
        },
    },
};
let SyracusMethod = class SyracusMethod extends xtrem_core_1.Node {
};
exports.SyracusMethod = SyracusMethod;
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        isNotEmpty: true,
        columnName: 'CODMET',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
    })
], SyracusMethod.prototype, "profession", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'INTMET',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.translatableTextDatatype,
    })
], SyracusMethod.prototype, "description", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFMEN',
        columnType: 'integer',
        filters: {
            lookup: {
                profile: 0,
            },
            control: {
                profile: 0,
            },
        },
        node: () => sageX3System.nodes.UserProfileMenu,
    })
], SyracusMethod.prototype, "menuProfile", void 0);
__decorate([
    xtrem_core_1.decorators.referenceProperty({
        isPublished: true,
        isStored: true,
        isNullable: true,
        columnName: 'PRFFCT',
        columnType: 'string',
        node: () => sageX3System.nodes.UserFunctionProfile,
    })
], SyracusMethod.prototype, "functionProfile", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'USRBI',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.AbiActivityCode],
    })
], SyracusMethod.prototype, "biUserProfile", void 0);
__decorate([
    xtrem_core_1.decorators.stringProperty({
        isPublished: true,
        isStored: true,
        columnName: 'PRFXTD',
        dataType: () => sageXtremX3SystemUtils.datatypes.genericDataTypes.textDatatype,
        serviceOptions: () => [sageX3System.serviceOptions.AytActivityCode],
    })
], SyracusMethod.prototype, "safeX3WasProfile", void 0);
exports.SyracusMethod = SyracusMethod = __decorate([
    xtrem_core_1.decorators.node({
        storage: 'external',
        tableName: 'AMETUTI',
        keyPropertyNames: ['profession'],
        indexes: [
            {
                orderBy: {
                    profession: 1,
                },
                isUnique: true,
                isNaturalKey: true,
            },
        ],
        externalStorageManager: new xtrem_x3_gateway_1.X3StorageManager({
            joins,
        }),
        isPublished: true,
        canRead: true,
        canSearch: true,
    })
], SyracusMethod);
//# sourceMappingURL=syracus-method.js.map