import { X3EnumDataType } from '@sage/xtrem-x3-gateway';
export declare enum ReportGroupEnum {
    supervisor = 1,
    masterData = 2,
    generalAccounting = 3,
    analyticalAccounting = 4,
    aRAndAP = 5,
    legalReports = 6,
    vat = 7,
    treasury = 8,
    openItems = 9,
    payments = 10,
    customerReminders = 11,
    salesExternalDocuments = 12,
    salesInternalDocuments = 13,
    salesPrices = 14,
    salesAnalysis = 15,
    salesListings = 16,
    purchasingParameters = 17,
    purchasingExternalDocuments = 18,
    purchasingInternalDocuments = 19,
    purchasingPrices = 20,
    purchasingAnalysis = 21,
    purchasingListings = 22,
    helpDesk = 23,
    commercialActivity = 24,
    stockCounts = 25,
    stockReordering = 26,
    listOfStockToMove = 27,
    stockAnalysis = 28,
    stockInternalDocuments = 29,
    manufacturingWeighing = 30,
    manufacturingReordering = 31,
    manufacturingWorkOrderDocuments = 32,
    manufacturingTechnicalData = 33,
    manufacturingValuation = 34,
    manufacturingAnalysis = 35,
    substituteValue36 = 36,
    iasReports = 37,
    fixedAssets = 38,
    specific = 39,
    fixedAssetsSetupAndCoreData = 40,
    fixedAssetsFixedAssets = 41,
    fixedAssetsMiscellaneous = 42,
    fixedAssetsPhysicalManagement = 43,
    fixedAssetsFunding = 44,
    operatingBudgets = 45,
    stockExternalDocuments = 46,
    hrPayrollManagement = 47,
    hrCharges = 48,
    hrHistorical = 49,
    hrLegalReports = 50,
    hrDadsU = 51,
    hrMiscellaneous = 52,
    hrProfitSharing = 53,
    hrTraining = 54,
    hrCareers = 55,
    hrTotalPayroll = 56,
    hrTimeManagement = 57,
    hrPayments = 58,
    hrStaffManagement = 59,
    vatOthers = 60,
    vatGermany = 61,
    vatSpain = 62,
    vatPortugal = 63,
    feesFrance = 64,
    feesBelgium = 65,
    feesUnitedStates = 66,
    vatAustria = 67,
    feesOthers = 68,
    vatBelgium = 69,
    assetManagementGermanyAndAustria = 70,
    assetManagementPortugal = 71,
    assetManagementItaly = 72,
    assetManagementUki = 73,
    assetManagementFrance = 74,
    notUsed = 75,
    vatFrance = 76,
    employee = 77,
    vatBoxesManagement = 78
}
export interface ReportGroup$EnumInterface {
    supervisor: 1;
    masterData: 2;
    generalAccounting: 3;
    analyticalAccounting: 4;
    aRAndAP: 5;
    legalReports: 6;
    vat: 7;
    treasury: 8;
    openItems: 9;
    payments: 10;
    customerReminders: 11;
    salesExternalDocuments: 12;
    salesInternalDocuments: 13;
    salesPrices: 14;
    salesAnalysis: 15;
    salesListings: 16;
    purchasingParameters: 17;
    purchasingExternalDocuments: 18;
    purchasingInternalDocuments: 19;
    purchasingPrices: 20;
    purchasingAnalysis: 21;
    purchasingListings: 22;
    helpDesk: 23;
    commercialActivity: 24;
    stockCounts: 25;
    stockReordering: 26;
    listOfStockToMove: 27;
    stockAnalysis: 28;
    stockInternalDocuments: 29;
    manufacturingWeighing: 30;
    manufacturingReordering: 31;
    manufacturingWorkOrderDocuments: 32;
    manufacturingTechnicalData: 33;
    manufacturingValuation: 34;
    manufacturingAnalysis: 35;
    substituteValue36: 36;
    iasReports: 37;
    fixedAssets: 38;
    specific: 39;
    fixedAssetsSetupAndCoreData: 40;
    fixedAssetsFixedAssets: 41;
    fixedAssetsMiscellaneous: 42;
    fixedAssetsPhysicalManagement: 43;
    fixedAssetsFunding: 44;
    operatingBudgets: 45;
    stockExternalDocuments: 46;
    hrPayrollManagement: 47;
    hrCharges: 48;
    hrHistorical: 49;
    hrLegalReports: 50;
    hrDadsU: 51;
    hrMiscellaneous: 52;
    hrProfitSharing: 53;
    hrTraining: 54;
    hrCareers: 55;
    hrTotalPayroll: 56;
    hrTimeManagement: 57;
    hrPayments: 58;
    hrStaffManagement: 59;
    vatOthers: 60;
    vatGermany: 61;
    vatSpain: 62;
    vatPortugal: 63;
    feesFrance: 64;
    feesBelgium: 65;
    feesUnitedStates: 66;
    vatAustria: 67;
    feesOthers: 68;
    vatBelgium: 69;
    assetManagementGermanyAndAustria: 70;
    assetManagementPortugal: 71;
    assetManagementItaly: 72;
    assetManagementUki: 73;
    assetManagementFrance: 74;
    notUsed: 75;
    vatFrance: 76;
    employee: 77;
    vatBoxesManagement: 78;
}
export type ReportGroup = keyof ReportGroup$EnumInterface;
export declare const reportGroupDatatype: X3EnumDataType<keyof ReportGroup$EnumInterface, unknown>;
//# sourceMappingURL=report-group.d.ts.map