"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDefaultSiteFromModule = exports.getSiteFromModule = exports.getUserProfile = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
async function getUserProfile(user) {
    if (user) {
        const functionProfile = await user.functionProfile;
        if (!functionProfile) {
            // eslint-disable-next-line prefer-destructuring
            const profession = await user.profession;
            if (profession) {
                return await profession.functionProfile;
            }
        }
        else {
            return functionProfile;
        }
    }
    return null;
}
exports.getUserProfile = getUserProfile;
async function getSiteFromModule(moduleNumber, profile) {
    const _edges = await profile.userProfileDefaultSites.query.edges;
    if (typesLib.gt(moduleNumber, 0) && typesLib.lt(moduleNumber, (_edges?.length ?? 0))) {
        return _edges[typesLib.sub(moduleNumber, 1)].node.site;
    }
    return null;
}
exports.getSiteFromModule = getSiteFromModule;
async function getDefaultSiteFromModule(user, moduleNumber) {
    const userProfile = await getUserProfile(user);
    if (userProfile) {
        return await getSiteFromModule(moduleNumber, userProfile);
    }
    return null;
}
exports.getDefaultSiteFromModule = getDefaultSiteFromModule;
//# sourceMappingURL=user-parameters-values.js.map