"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SupportServiceManagementGs1Page = void 0;
const xtrem_decimal_1 = require("@sage/xtrem-decimal"), typesLib = xtrem_decimal_1;
const ui = require("@sage/xtrem-ui");
const screen_management_gs_1_1 = require("./screen-management-gs-1");
const management_service_gs_1_1 = require("./management-service-gs-1");
const defaultManagementServiceKey = 'DEFAULT_MOBILE_COMPOSITE_GS_1_DATA_KEY';
class SupportServiceManagementGs1Page extends ui.Page {
    /**
     * Internal only
     */
    constructor() {
        super();
        /**
         * Used only for disable scan operation (service must stay active)
         */
        /** @internal */
        this._disableServiceGs1 = false;
        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(defaultManagementServiceKey);
    }
    /**
     * Initialize ControlManagerGs1
     *
     * @param site current site
     * @param compositePageKey key for storage operation
     * @param dictionaryFieldSupported fields screen to manage and control
     * @param dictionaryDataComposites? optional composite data
     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them
     * @returns true when ControlManagerGs1 has usable
     */
    /** @internal */
    async _createAndInitControlManagerGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed) {
        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(compositePageKey);
        // Including erroneous field misspelled dateTestFake instead dateTest
        if (site && compositePageKey) {
            if ((await this._controlManagerGs1
                .initialize(this, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed)
                .catch(() => false))) {
                return true;
            }
            else {
                // Error detected, abort controller
                ui.console.error(`Service initialization failure for site ${site}`);
            }
        }
        // Initialization failure : reset to default instance
        this._controlManagerGs1 = new management_service_gs_1_1.ManagementServiceGs1(defaultManagementServiceKey);
        return false;
    }
    /**
     * Protected only
     */
    /**
     * Return current state of service
     */
    /** @protected */
    get isServiceGs1Disabled() {
        return this._disableServiceGs1;
    }
    /**
     * Disable or enable service (default : enable) :
     * Disabling clearing all composite data
     */
    /** @protected */
    set disableServiceGs1(disableServiceGs1) {
        this._disableServiceGs1 = disableServiceGs1;
        if (this._disableServiceGs1) {
            this._controlManagerGs1.clearCompositeData();
        }
    }
    /**
     * Get current control manager instance
     */
    /** @protected */
    get controlManagerGs1() {
        return this._controlManagerGs1;
    }
    /**
     * Remove composite data
     */
    /** @protected */
    clearCompositeData() {
        this._controlManagerGs1.clearCompositeData();
    }
    /**
     * Remove composite data from storage
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    /** @protected */
    clearCompositeDataStorage(storageKey) {
        this._controlManagerGs1.clearCompositeDataStorage(this, storageKey);
    }
    /**
     * Remove all composite and storage data
     * @param storageKey optional, for overriding current service key (use with caution)
     */
    /** @protected */
    clearAllCompositeDataAndStorage(storageKey) {
        this._controlManagerGs1.clearAllCompositeDataAndStorage(this, storageKey);
    }
    /**
     * Create and initialize manager for a given service :
     * manager stay available only when site has defined and initialization is done.
     *
     * @param site current site
     * @param compositePageKey key for storage operation
     * @param dictionaryFieldSupported fields screen to manage and control
     * @param dictionaryDataComposites? optional composite data
     * @param checkCompositeDataAllowed? optional client callback to check composite data code before to dispatch them
     * @return false when service has not properly initialized (unavailable)
     */
    /** @protected */
    async createAndInitServiceGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed) {
        if (!site ||
            !(await this._createAndInitControlManagerGs1(site, compositePageKey, dictionaryFieldSupported, dictionaryDataComposites, checkCompositeDataAllowed))) {
            ui.console.error(`Unable to initialize service control manager Gs 1 for site ${site}`);
            return false;
        }
        return true;
    }
    /**
     * Load composite data from storage and erase them
     * @returns true when some data has been loaded
     */
    /** @protected */
    loadCompositeData() {
        return this._controlManagerGs1.loadCompositeData(this);
    }
    /**
     * Save composite data, zero elements allowed
     * @returns true when operation has performed
     */
    /** @protected */
    saveCompositeData() {
        return this._controlManagerGs1.saveCompositeData(this);
    }
    /**
     * call scan evaluator only when manager available and rawData has minimum requirement
     * @param mainField current screen field reference
     * @param rawData data to parse
     * @return false when is not a bar code composite
     */
    /** @protected */
    async scanBarCode(mainField, rawData) {
        // class must be created, initialized and not busy, data must be started by a numeric value,
        // minimum size 2 to 4 numerics or prefix ]<alphabetic><numeric>
        if (!(this._disableServiceGs1 ?? false) && typesLib.gt(rawData.length, 4) &&
            Number(rawData.match(screen_management_gs_1_1.compositeCodePrefix)?.length)) {
            return (await this._controlManagerGs1
                .scan(this, mainField, rawData)
                .catch(() => false));
        }
        return false;
    }
    /**
     * Update screen fields supported (only when exists Gs1 parameters).
     * mapping field has been performed after
     * @param dictionaryFieldSupported dictionary of page fields submitted
     * @returns true when done, false when no any field to process with data
     */
    async setScreenFieldSupported(dictionaryFieldSupported) {
        return await this._controlManagerGs1.setScreenFieldSupported(this, dictionaryFieldSupported);
    }
}
exports.SupportServiceManagementGs1Page = SupportServiceManagementGs1Page;
//# sourceMappingURL=support-service-management-gs-1-page.js.map